\name{train_models}
\alias{train_models}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
makes a model object using the specified algorithms.
}
\description{
Creates a trained model using the specified algorithms.
}
\usage{
train_models(container, algorithms, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{container}{
Class of type \code{\link{matrix_container-class}} generated by the \code{\link{create_container}} function.
}
  \item{algorithms}{
List of algorithms as a character vector (e.g. \code{c("SVM","MAXENT")}).
}
  \item{\dots}{
Other parameters to be passed on to \code{\link{train_model}}.
}
}
\details{
Calls the \code{\link{train_model}} function for each algorithm you list.
}
\value{
Returns a \code{list} of trained models that can be subsequently used in \code{\link{classify_models}} to classify new data.
}
\author{
Wouter Van Atteveldt <wouter@vanatteveldt.com>
}
\examples{
library(RTextTools)
data(NYTimes)
data <- NYTimes[sample(1:3100,size=100,replace=FALSE),]
matrix <- create_matrix(cbind(data["Title"],data["Subject"]), language="english", 
removeNumbers=TRUE, stemWords=FALSE, weighting=tm::weightTfIdf)
container <- create_container(matrix,data$Topic.Code,trainSize=1:75, testSize=76:100, 
virgin=FALSE)
models <- train_models(container, algorithms=c("MAXENT","SVM"))
}
\keyword{method}
