% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swapCOM.R
\name{swapCOM}
\alias{swapCOM}
\title{\code{swapCOM}}
\usage{
swapCOM(
  futures = futs,
  futuresNames = c("CL0M", "CL0N"),
  pricingDates = c("2020-05-01", "2020-05-30"),
  contract = "cmewti",
  exchange = "nymex"
)
}
\arguments{
\item{futures}{Wide data frame of futures prices for the given swap pricing dates}

\item{futuresNames}{Tickers of relevant futures contracts}

\item{pricingDates}{Vector of start and end pricing dates as character. See example.}

\item{contract}{Contract code in data(expiry_table). sort(unique(expiry_table$cmdty)) for options.}

\item{exchange}{Exchange code in data(holidaysOil). Currently only "nymex" and "ice" supported.}
}
\value{
Data frame of histocial swap prices.
}
\description{
Commodity swap pricing from exchange settlement
}
\examples{
\dontrun{
c <- paste0("CL0",c("M","N","Q"))
futs <-getPrices(feed="CME_NymexFutures_EOD",contracts = c,from="2019-08-26",
iuser = username, ipassword = password)
swapCOM(futures = futs, futuresNames=c("CL0M","CL0N"),
pricingDates = c("2020-05-01","2020-05-30"), contract = "cmewti", exchange = "nymex")
}
}
\author{
Philippe Cote
}
