% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promptBeta.R
\name{promptBeta}
\alias{promptBeta}
\title{\code{promptBeta}}
\usage{
promptBeta(x = x, period = "all", betatype = "all", output = "chart")
}
\arguments{
\item{x}{Wide dataframe with date column and multiple series columns (multivariate).}

\item{period}{"all" or numeric period of time in last n periods.}

\item{betatype}{"all" "bull" "bear".}

\item{output}{"betas", "chart","stats"}
}
\value{
ggplot chart, df of betas or stats
}
\description{
Returns betas of multiple xts prices (by using relative returns).
}
\examples{
\dontrun{
x <- dflong \%>\% dplyr::filter(grepl("CL",series))
x <- x \%>\% dplyr::mutate(series=readr::parse_number(series)) \%>\% dplyr::group_by(series)
x <- returns(df=x,retType="abs",period.return=1,spread=TRUE)
x <- rolladjust(x=x,commodityname=c("cmewti"),rolltype=c("Last.Trade"))
promptBeta(x=x,period="all",betatype="all",output="chart")
promptBeta(x=x,period="all",betatype="all",output="betas")
promptBeta(x=x,period="all",betatype="all",output="stats")
}
}
\author{
Philippe Cote
}
