% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sep.rb.hypergeo.varse}
\alias{sep.rb.hypergeo.varse}
\title{Hypergeometric risk-based population sensitivity for varying unit sensitivity}
\usage{
sep.rb.hypergeo.varse(pstar, rr, N, df)
}
\arguments{
\item{pstar}{design prevalence (scalar)}

\item{rr}{relative risk values (vector of values corresponding
to the number of risk strata)}

\item{N}{vector of population size for each risk group, corresponding to rr values
(vector of equal length to rr)}

\item{df}{dataframe of values for each combination of risk stratum and
sensitivity level,
col 1 = risk group index, col 2 = unit Se, col 3 = n
(sample size for risk group and unit sensitivity)}
}
\value{
list of 5 elements, a scalar of population-level sensitivity
  a vector of EPI values, a vector of corresponding Adjusted risks
  a vector of sample sizes (n) per risk group and a vector of
  mean unit sensitivities per risk group
}
\description{
Calculates population sensitivity for a single risk factor
  and varying unit sensitivity using hypergeometric approximation method
  (assumes known population size)
}
\examples{
# examples for sep.rb.hypergeo.varse
rg<- c(1, 1, 2, 2)
se<- c(0.92, 0.85, 0.92, 0.85)
n<- c(80, 30, 20, 30)
df<- data.frame(rg, se, n)
sep.rb.hypergeo.varse(0.01, c(5, 1), c(200, 1800), df)

rg<- c(1, 1, 2, 2)
se<- c(0.95, 0.8, 0.95, 0.8)
n<- c(20, 10, 10, 5)
df<- data.frame(rg, se, n)
sep.rb.hypergeo.varse(0.05, c(3, 1), c(100, 400), df)

rg<- c(rep(1, 30), rep(2, 15))
se<- c(rep(0.95, 20), rep(0.8, 10), rep(0.95, 10), rep(0.8, 5))
n<- rep(1, 45)
df<- data.frame(rg, se, n)
sep.rb.hypergeo.varse(0.02, c(3, 1), c(100, 400), df)

rg<- c(1, 2, 3, 1, 2, 3)
se<- c(0.95, 0.95, 0.95, 0.8, 0.8, 0.8)
n<- c(20, 10, 10, 30, 5, 5)
df<- data.frame(rg, se, n)
sep.rb.hypergeo.varse(0.01, c(5, 3, 1), c(100, 300, 600), df)
}
\keyword{methods}

