% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sep.rb.bin.varse}
\alias{sep.rb.bin.varse}
\title{Binomial risk-based population sensitivity for varying unit sensitivity}
\usage{
sep.rb.bin.varse(pstar, rr, ppr, df)
}
\arguments{
\item{pstar}{design prevalence (scalar)}

\item{rr}{relative risk values (vector of values corresponding
to the number of risk strata)}

\item{ppr}{population proportions corresponding to rr values
(vector of equal length to rr)}

\item{df}{dataframe of values for each combination of risk stratum and
sensitivity level,
col 1 = risk group index, col 2 = unit Se, col 3 = n
(sample size for that risk group and unit sensitivity)}
}
\value{
list of 3 elements, a scalar of population-level sensitivity
  a vector of EPI values and a vector of corresponding adjusted risks
}
\description{
Calculates population sensitivity for a single risk factor
  and varying unit sensitivity using binomial method (assumes large population)
}
\examples{
# examples for sep.rb.bin.varse
rg<- c(1, 1, 2, 2)
se<- c(0.92, 0.85, 0.92, 0.85)
n<- c(80, 30, 20, 30)
df<- data.frame(rg, se, n)
sep.rb.bin.varse(0.01, c(5, 1), c(0.1, 0.9), df)

rg<- c(1, 1, 2, 2)
se<- c(0.95, 0.8, 0.95, 0.8)
n<- c(20, 10, 10, 5)
df<- data.frame(rg, se, n)
sep.rb.bin.varse(0.05, c(3, 1), c(0.2, 0.8), df)

rg<- c(rep(1, 30), rep(2, 15))
se<- c(rep(0.95, 20), rep(0.8, 10), rep(0.95, 10), rep(0.8, 5))
n<- rep(1, 45)
df<- data.frame(rg, se, n)
sep.rb.bin.varse(0.02, c(3, 1), c(0.2, 0.8), df)

rg<- c(1, 2, 3, 1, 2, 3)
se<- c(0.95, 0.95, 0.95, 0.8, 0.8, 0.8)
n<- c(20, 10, 10, 30, 5, 5)
df<- data.frame(rg, se, n)
sep.rb.bin.varse(0.01, c(5, 3, 1), c(0.1, 0.3, 0.6), df)
}
\keyword{methods}

