% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_api_prj.R
\name{prj_unload}
\alias{prj_unload}
\title{Unloads last loaded project.}
\usage{
prj_unload()
}
\value{
Project unloaded or NULL if there was no project to unload.
}
\description{
It changes \code{.libPaths()} removing all references to currently loaded
project internal environment.
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

cat(.libPaths(), sep = "\\n") # show inital contents of .libPaths()

prj_load(prj = prj) # load project
cat(.libPaths(), sep = "\\n") # show contents of .libPaths()

prj_unload() # restore environment
cat(.libPaths(), sep = "\\n") # show final contents of .libPaths()

}
\seealso{
Other in project management: \code{\link{prj_build}},
  \code{\link{prj_clean_deps}}, \code{\link{prj_init}},
  \code{\link{prj_install_deps}}, \code{\link{prj_load}},
  \code{\link{prj_lock_env}}, \code{\link{prj_pack}},
  \code{\link{prj_start_package}}, \code{\link{prj_start}},
  \code{\link{prj_zip}}
}
