% Generated by roxygen2 (4.0.2): do not edit by hand
\name{art2}
\alias{art2}
\alias{art2.default}
\title{Create and train an art2 network}
\usage{
art2(x, ...)

\method{art2}{default}(x, f2Units = 5, maxit = 100,
  initFunc = "ART2_Weights", initFuncParams = c(0.9, 2),
  learnFunc = "ART2", learnFuncParams = c(0.98, 10, 10, 0.1, 0),
  updateFunc = "ART2_Stable", updateFuncParams = c(0.98, 10, 10, 0.1, 0),
  shufflePatterns = TRUE, ...)
}
\arguments{
\item{x}{a matrix with training inputs for the network}

\item{...}{additional function parameters (currently not used)}

\item{f2Units}{controls the number of clusters assumed to be present}

\item{maxit}{maximum of iterations to learn}

\item{initFunc}{the initialization function to use}

\item{initFuncParams}{the parameters for the initialization function}

\item{learnFunc}{the learning function to use}

\item{learnFuncParams}{the parameters for the learning function}

\item{updateFunc}{the update function to use}

\item{updateFuncParams}{the parameters for the update function}

\item{shufflePatterns}{should the patterns be shuffled?}
}
\value{
an \code{\link{rsnns}} object. The \code{fitted.values} member contains the
activation patterns for all inputs.
}
\description{
ART2 is very similar to ART1, but for real-valued input. See \code{\link{art1}}
for more information. Opposed to the ART1 implementation, the ART2 implementation
does not assume two-dimensional input.
}
\details{
As comparison of real-valued vectors is more difficult than comparison of binary vectors,
the comparison layer is more complex in ART2, and actually consists of three layers. With a more
complex comparison layer, also other parts of the network enhance their complexity.
In SNNS, this enhanced complexity is reflected by the presence of more parameters in initialization-, learning-,
and update function.

In analogy to the implementation of ART1, there are one initialization function, one learning function and two
update functions suitable for ART2.  The learning and update functions have five parameters, the initialization function has two
parameters. For details see the SNNS User Manual, p. 67 and pp. 192.
}
\examples{
\dontrun{demo(art2_tetra)}
\dontrun{demo(art2_tetraSnnsR)}


data(snnsData)
patterns <- snnsData$art2_tetra_med.pat

model <- art2(patterns, f2Units=5, learnFuncParams=c(0.99, 20, 20, 0.1, 0),
                  updateFuncParams=c(0.99, 20, 20, 0.1, 0))
model

testPatterns <- snnsData$art2_tetra_high.pat
predictions <- predict(model, testPatterns)

\dontrun{library(scatterplot3d)}

\dontrun{par(mfrow=c(2,2))}
\dontrun{scatterplot3d(patterns, pch=encodeClassLabels(model$fitted.values))}
\dontrun{scatterplot3d(testPatterns, pch=encodeClassLabels(predictions))}
}
\references{
Carpenter, G. A. & Grossberg, S. (1987), 'ART 2: self-organization of stable category recognition codes for analog input patterns', Appl. Opt. 26(23), 4919--4930.

Grossberg, S. (1988), Adaptive pattern classification and universal recoding. I.: parallel development and coding of neural feature detectors, MIT Press, Cambridge, MA, USA, chapter I, pp. 243--258.

Herrmann, K.-U. (1992), 'ART -- Adaptive Resonance Theory -- Architekturen, Implementierung und Anwendung', Master's thesis, IPVR, University of Stuttgart. (in German)

Zell, A. et al. (1998), 'SNNS Stuttgart Neural Network Simulator User Manual, Version 4.2', IPVR, University of Stuttgart and WSI, University of Tübingen.
\url{http://www.ra.cs.uni-tuebingen.de/SNNS/}

Zell, A. (1994), Simulation Neuronaler Netze, Addison-Wesley. (in German)
}
\seealso{
\code{\link{art1}}, \code{\link{artmap}}
}

