% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.cov.R
\name{sym.cov}
\alias{sym.cov}
\title{Symbolic Covariance}
\usage{
sym.cov(sym.var.x, sym.var.y, method = c('centers', 'interval', 'billard', 'modal'),
na.rm = FALSE, ...)
}
\arguments{
\item{sym.var.x}{First symbolic variables.}

\item{sym.var.y}{Second symbolic variables.}

\item{method}{The method to be use.}

\item{na.rm}{As in R cov function.}

\item{...}{As in R cov function.}
}
\value{
Return a real number.
}
\description{
This function compute the symbolic covariance.
}
\examples{
data(example3)
sym.data<-example3
sym.cov(sym.var(sym.data,1),sym.var(sym.data,4),method='centers')
sym.cov(sym.var(sym.data,2),sym.var(sym.data,6),method='centers')
sym.cov(sym.var(sym.data,2),sym.var(sym.data,6),method='billard')

}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Covariance}
\keyword{Symbolic}
