% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor.sym.data.table.R
\name{cor}
\alias{cor}
\alias{cor.default}
\alias{cor.sym.data.table}
\title{Generic function for the correlation}
\usage{
cor(x, ...)

\method{cor}{default}(x, y = NULL, use = "everything",
  method = c("pearson", "kendall", "spearman"), ...)

\method{cor}{sym.data.table}(x, y, method = c("centers", "interval",
  "billard", "modal"), ...)
}
\arguments{
\item{x}{A symbolic variable.}

\item{...}{As in R cor function.}

\item{y}{A symbolic variable.}

\item{use}{An optional character string giving a method for computing
covariances in the presence of missing values. This must be (an abbreviation of)
 one of the strings "everything", "all.obs", "complete.obs", "na.or.complete",
 or "pairwise.complete.obs".}

\item{method}{The method to be use.}
}
\value{
Return a real number in [-1,1].
}
\description{
This function compute the symbolic correlation
}
\examples{
data(example3)
sym.data <- example3
cor(sym.data[,1], sym.data[,4], method='centers')
cor(sym.data[,2], sym.data[,6], method='centers')
cor(sym.data[,2], sym.data[,6], method='billard')
}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Correlation}
\keyword{Symbolic}
