% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.variance.R
\name{sym.variance}
\alias{sym.variance}
\title{Symbolic Variance}
\usage{
sym.variance(sym.var, method = c('centers', 'interval', 'billard', 'modal'),
 na.rm = FALSE, ...)
}
\arguments{
\item{sym.var}{The symbolic variable.}

\item{method}{The method to be use.}

\item{na.rm}{As in R var function.}

\item{...}{As in R var function.}
}
\value{
Return a real number.
}
\description{
Compute the symbolic variance.
}
\examples{
data(example3)
sym.data<-example3
sym.variance(sym.var(sym.data,1))
sym.variance(sym.var(sym.data,2))
sym.variance(sym.var(sym.data,6))
sym.variance(sym.var(sym.data,6),method='interval')
sym.variance(sym.var(sym.data,6),method='billard')
sym.variance(sym.var(sym.data,3),method='modal')
}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Symbolic}
\keyword{Variance}
