% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.union.polygons}
\alias{rsaga.union.polygons}
\title{Spatial union of two polygon layers}
\usage{
rsaga.union.polygons(
  layer_a = NULL,
  layer_b = NULL,
  result = NULL,
  split = FALSE,
  load = NULL,
  env = rsaga.env()
)
}
\arguments{
\item{layer_a}{A \code{character} string representing the path to a polygon
shapefile.}

\item{layer_b}{A \code{character} string representing the path to a polygon
shapefile with which to union layer_a.}

\item{result}{\code{character}, path indicating where to store the output
shapefile.}

\item{split}{If \code{TRUE}, multipart polygons become separated polygons
(default: FALSE).}

\item{load}{Deprecated, will be removed in a future release. Ignored
if \code{FALSE}, and causes an error if \code{TRUE}  (default: NULL)}

\item{env}{RSAGA geoprocessing environment created by
\code{\link[=rsaga.env]{rsaga.env()}}, required because module(s) depend(s) on SAGA
version.}
}
\value{
The function saves the output shapefile to the path indicated in
function argument \code{result}.
}
\description{
The function \code{rsaga.union.polygons} uses SAGA function
"\code{Union}" to calculate the geometric union of two polygon layers. This
corresponds to the intersection and the symmetrical difference of the two
layers.
}
\details{
Function \code{gUnion()} in \code{rgeos} package can also be used for joining
intersecting polygon geometries. However,
\code{\link[=rsaga.union.polygons]{rsaga.union.polygons()}} will be usually much faster,
especially when joining thousands of polygons.
}
\author{
Jannes Muenchow and Alexander Brenning (R interface), Olaf Conrad and Angus Johnson (SAGA
modules)
}
\keyword{operations}
\keyword{polygons}
\keyword{vector}
