% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerplot.R
\name{powerplot}
\alias{powerplot}
\title{Power plots for multivariate RR methods}
\usage{
powerplot(numRep, n = c(100, 500, 1000), pi, cor = c(0, 0.1, 0.3),
  b.log = NULL, model, p, method = c("RRcor", "RRlog", "RRlin"),
  complyRates = c(1, 1), sysBias = c(0, 0), groupRatio = 0.5,
  alpha = 0.05, nCPU = 1, show.messages = TRUE)
}
\arguments{
\item{numRep}{number of boostrap replications}

\item{n}{vector of samples sizes}

\item{pi}{true prevalence}

\item{cor}{vector of true correlations}

\item{b.log}{vector of true logistic regression coefficients}

\item{model}{randomized response model}

\item{p}{randomization probability}

\item{method}{multivariate RR method}

\item{complyRates}{probability of compliance within carriers/noncarriers of sensitive attribute}

\item{sysBias}{probability of responding 'yes' in case of noncompliance}

\item{groupRatio}{ratio of subgroups in two-group RR designs}

\item{alpha}{type-I error used to estimate power}

\item{nCPU}{either the number of CPU cores or a cluster initialized via \code{\link[parallel]{makeCluster}}.}

\item{show.messages}{toggle printing of progress messages}
}
\value{
a list of the class \code{powerplot} containing an array \code{res} with the power estimates and details of the simulation (e.g., model, p, pi, etc.)
}
\description{
Uses the function \code{\link{RRsimu}} to estimate the power of the multivariate RR methods (correlation \code{\link{RRcor}}, logistic regression \code{\link{RRlog}}, and/or linear regression \code{\link{RRlin}}.
}
\examples{
# Not run
# pplot <- powerplot(100, n=c(150,250), cor=c(0,.3,.5),
#                   method="RRlog", pi=.6, model="Warner", p=.3)
# plot(pplot)
}
\seealso{
\code{\link{RRsimu}} for Monte-Carlo simulation / parametric bootstrap
}
