% Generated by roxygen2 (4.0.2): do not edit by hand
\name{RRlin}
\alias{RRlin}
\title{Linear randomized response regression}
\usage{
RRlin(formula, data, models, p.list, group = NULL, Kukrep = 1, bs.n = 0,
  nCPU = 1, maxit = 500, pibeta = 0.05)
}
\arguments{
\item{formula}{a continuous criterion is predicted by one or more categorical RR variables defined by \code{models}. If the number of predictors exceeds the number defined by the vector \code{models}, the remaining predictors are treated as non-randomized variables (e.g., direct questions). At the moment, only additive effects (no interactions) can be used.}

\item{data}{an optional data frame, list or environment, containing the variables in the model.}

\item{models}{vector specifying RR model(s) in order of appearance in formula}

\item{p.list}{list of randomization probabilities for RR models in the same order as specified in \code{models}. Note, that the randomization probabilities p must be provided in a \code{\link{list}}, e.g., \code{list(p=c(.2, .3))}}

\item{group}{vector or matrix specifying group membership by the indices 1 and 2. Only for multigroup RR models, e.g., \code{UQTunknown}, \code{CDM} or \code{SLD}}

\item{Kukrep}{defines the number of repetitions in Kuk's card playing method}

\item{bs.n}{Number of samples used for the non-parametric bootstrap}

\item{nCPU}{Number of cores used for the bootstrap}

\item{maxit}{maximum number of iterations in optimization routine}

\item{pibeta}{approximate ratio of probabilities pi to regression weights beta (to adjust scaling). Can be used for speeding-up and fine-tuning ML estimation (i.e., choosing a smaller value for larger beta values).}
}
\value{
Returns an object \code{RRlin} which can be analysed by the generic method \code{\link{summary}}
}
\description{
Linear regression for a continuous criterion, using randomized-response (RR) variables as predictors.
}
\examples{
# generate first RR predictor
dat <- RRgen(n=500, pi=.3, model="Warner", p=.3)
# generate a second RR predictor (forced response design)
dat2 <- RRgen(n=500, pi=c(.4,.6), model="FR", p=c(.1,.15))
dat$FR <- dat2$response
dat$trueFR <- dat2$true
# generate a third, continuous predictor
dat$nonRR <- rnorm(500, 5, 1)
# compute dependent variable as linear combination of predictors
dat$depvar <- 2*dat$true - 3*dat2$true + .5*dat$nonRR +rnorm(500, 1, 7)

# analyze with RRlin
linreg <- RRlin(depvar~response+FR+nonRR, data=dat,
                models=c("Warner","FR"),p.list=list(.3, c(.1,.15)))
summary(linreg)
# compare results to coeeficients of an ordinary linear regression
summary(lm(depvar~true +trueFR+nonRR, data=dat))
}
\author{
Daniel W. Heck
}
\references{
van den Hout, A., & Kooiman, P. (2006). Estimating the linear regression model with categorical covariates subject to randomized response. \emph{Computational Statistics & Data Analysis, 50}, 3311-3323.
}
\seealso{
\code{vignette('RRreg')} or \url{https://dl.dropboxusercontent.com/u/21456540/RRreg/index.html} for a detailed description of the RR models and the appropriate definition of \code{p}
}

