% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niftyreg.R
\name{forward}
\alias{forward}
\alias{forward.niftyreg}
\alias{reverse}
\alias{reverse.niftyreg}
\title{Extract forward and reverse transformations}
\usage{
forward(object, ...)

\method{forward}{niftyreg}(object, i = 1L, ...)

reverse(object, ...)

\method{reverse}{niftyreg}(object, i = 1L, ...)
}
\arguments{
\item{object}{An R object.}

\item{...}{Additional arguments. Not currently used.}

\item{i}{The transformation number to extract. There will only be more than
one in the case of multiple registration.}
}
\value{
A transformation object, an image or affine matrix, with suitable
  attributes giving pointers to source and target images. If there is no
  transformation information in the object then \code{NULL} is returned.
}
\description{
These functions extract forward and reverse transformations in a form
compatible with \code{\link{applyTransform}} and other functions. They are
(S3) generic, but only methods for \code{"niftyreg"} objects currently
exist.
}
\seealso{
\code{\link{niftyreg}}, \code{\link{applyTransform}}
}
\author{
Jon Clayden <code@clayden.org>
}
