#' Simulated Genotypes
#' 
#' Simulated genotypes for 1000 subjects at 1000 loci. Genotypes were simulated 
#' with use of hapgen2, and are based on the haplotype structure of human 
#' chromosome one in the CEU population of the 1000 Genomes Project.
#' @format An integer matrix with 1000 rows and 1000 columns
#' \describe{ 
#'    \item{s1-s1000}{s[i] is an integer vector of minor allele counts for the ith subject.}
#' }
"G"

#' Population Structure Adjustments
#' 
#' First two principal components of the centered and scaled subject by locus 
#' genotype matrix. Note that principal components were calculated using
#' genotype at more loci than are provided in the example data set.
#' @format A numeric matrix with 1000 rows and 2 columns
#' \describe{
#'    \item{pc1}{The first principal component.}
#'    \item{pc2}{The second principal component.}
#' }
"S"

#' Simulated Covariates
#' 
#' Age and sex simulated for 1000 subjects. Age was drawn from a gamma
#' distribution with mean 50 and variance 10. Sex was drawn from a Bernoulli
#' distribuiton with expectation 1/2. 
#' @format A numeric matrix with 1000 rows and 2 columns
#' \describe{
#'    \item{Age}{Age.}
#' ,,,\item{Sex}{Sex.}
#' }
"X"

#' Simulated Phenotypes
#' 
#' Two independent phenotypes simulated under the null hypothesis of no
#' genotypic effect. A subject specific linear predictor was calculated based on
#' age, sex, pc1, and pc2. The normal phenotype was generated by adding N(0,1) noise
#' to the linear predictor. The log-normal phenotype was generated by adding N(0,1) noise,
#' then exponentiating.
#' @format A numeric matrix with 1000 rows and 2 columns
#' \describe{
#'    \item{YN}{Normal phenotype.}
#'    \item{YL}{Log-normal phenotype.}
#' }
"Y"
