% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXTCOMP_getter.R
\name{getCompletedData}
\alias{getCompletedData}
\title{Get the completed data from MixtComp object}
\usage{
getCompletedData(outMixtComp, var = NULL, with.z_class = FALSE)
}
\arguments{
\item{outMixtComp}{object of class \emph{MixtCompLearn} or \emph{MixtComp} obtained using \code{mixtCompLearn} or
\code{mixtCompPredict} functions from \code{RMixtComp} package or \code{rmcMultiRun} from \code{RMixtCompIO} package.}

\item{var}{Name of the variables for which to extract the completed data. Default is NULL (all variables are extracted)}

\item{with.z_class}{if TRUE, z_class is returned with the data.}
}
\value{
a matrix with the data completed by MixtComp (z_class is in the first column and then variables are sorted in
alphabetic order, it may differ from the original order of the data).
}
\description{
Get the completed data from MixtComp object (does not manage functional models)
}
\examples{
require(RMixtCompIO) # for learning a mixture model
dataLearn <- list(
  var1 = as.character(c(rnorm(50, -2, 0.8), rnorm(50, 2, 0.8))),
  var2 = as.character(c(rnorm(50, 2), rpois(50, 8)))
)

# add missing values
dataLearn$var1[12] <- "?"
dataLearn$var2[72] <- "?"

model <- list(
  var1 = list(type = "Gaussian", paramStr = ""),
  var2 = list(type = "Poisson", paramStr = "")
)

algo <- list(
  nClass = 2,
  nInd = 100,
  nbBurnInIter = 100,
  nbIter = 100,
  nbGibbsBurnInIter = 100,
  nbGibbsIter = 100,
  nInitPerClass = 3,
  nSemTry = 20,
  confidenceLevel = 0.95,
  ratioStableCriterion = 0.95,
  nStableCriterion = 10,
  mode = "learn"
)

resLearn <- rmcMultiRun(algo, dataLearn, model, nRun = 3)

# get completedData
completedData <- getCompletedData(resLearn)
completedData2 <- getCompletedData(resLearn, var = "var1")

}
\seealso{
Other getter: 
\code{\link{getBIC}()},
\code{\link{getEmpiricTik}()},
\code{\link{getMixtureDensity}()},
\code{\link{getParam}()},
\code{\link{getPartition}()},
\code{\link{getType}()}
}
\author{
Quentin Grimonprez
}
\concept{getter}
