% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.MARK.r
\name{export.MARK}
\alias{export.MARK}
\title{Export data and models for import in MARK}
\usage{
export.MARK(x, project.name, model = NULL, replace = FALSE, chat = 1,
  title = "", ind.covariates = "all")
}
\arguments{
\item{x}{processed data list used to build models}

\item{project.name}{character string to be used for prefix of filenames and
for MARK project name; do not use "." in the filename}

\item{model}{either a single mark model or a marklist}

\item{replace}{if TRUE it will replace any existing files}

\item{chat}{user-specified chat value if desired}

\item{title}{MARK project title string}

\item{ind.covariates}{vector of character strings specifying names of
individual covariates or "all" to use all present}
}
\value{
None
}
\description{
Creates a .Rinp, .inp and optionally renamed output files that can be
imported into MARK to create a new MARK project with all the data and output
files.
}
\details{
If you use Nest model and NestAge covariate you should use the processed
data list (model$data) from a model using NestAge in the formula because the
necessary individual covariates are added to the processed data list.  Also,
use default of ind.covariates="all".

After running this function to export the data and models to the working
directory, start program MARK and select the File/RMARK Import menu item.
Navigate to the working directory and select the "project.name".Rinp file.
MARK will take over and create the project files and will import any
specified model output files.

DO NOT use a "project name" that is the same as a filename you use as input
(*.inp) to RMark because this function will create a file "project name".inp
and it would over-write your existing file and the format could change. If
you try this, the code will return an error that the filename is invalid
because the file already exists.
}
\examples{
\donttest{
# This example is excluded from testing to reduce package check time
data(mallard)
Dot=mark(mallard,nocc=90,model="Nest",
	model.parameters=list(S=list(formula=~1)))
mallard.proc=process.data(mallard,nocc=90,model="Nest")
export.MARK(mallard.proc,"mallard",Dot,replace=TRUE)
data(robust)
time.intervals=c(0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0)
S.time=list(formula=~time)
p.time.session=list(formula=~-1+session:time,share=TRUE)
GammaDoublePrime.random=list(formula=~time,share=TRUE)
model.1=mark(data = robust, model = "Robust",
	time.intervals=time.intervals,
	model.parameters=list(S=S.time,
			GammaDoublePrime=GammaDoublePrime.random,p=p.time.session))
robust.proc=process.data(data = robust, model = "Robust",
	time.intervals=time.intervals)
export.MARK(robust.proc,"robust",	model.1,replace=TRUE)
}
}
\author{
Jeff Laake
}
\seealso{
\code{\link{export.chdata}}, \code{\link{export.model}}
}
\keyword{utility}

