% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.monthly.climate.R
\name{is.monthly.climate}
\alias{is.monthly.climate}
\title{Verifies if 'climate' represents the monthly climatology in one year, i.e  'climate' is monthly.climate type matrix whose rows represent months and each column represents a station. It is also used in \code{\link{setComprehensiveTemperatureGeneratorParameters}}.}
\usage{
is.monthly.climate(climate, nstation = 3, nmonth = 12,
  verbose = TRUE)
}
\arguments{
\item{climate}{matrix containing the 'monthly climatology' data}

\item{nstation}{number of variable measurement stations (columns of the matrix 'climate')}

\item{nmonth}{number of months in one year (it can be different if climate is represented by seasonal avarages or others), Default is 12 (recommended). (it can be different if climate is represented by seasonal averages, in this case 4)}

\item{verbose}{Prints output and warining messagrs only if is \code{TRUE}.}
}
\value{
A logical variable if the matrix 'climate' is monthly.climate type
}
\description{
Verifies if 'climate' represents the monthly climatology in one year, i.e  'climate' is monthly.climate type matrix whose rows represent months and each column represents a station. It is also used in \code{\link{setComprehensiveTemperatureGeneratorParameters}}.
}
\seealso{
\code{\link{setComprehensiveTemperatureGeneratorParameters}}
}
\author{
Emanuele Cordano, Emanuele Eccel
}
