% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuity_ratio.R
\name{continuity_ratio}
\alias{continuity_ratio}
\title{Calculates the continuity ratio of a set of precipitation measured or generated data in several sites as defined by Wilks, 1998 (see reference link)}
\usage{
continuity_ratio(data, lag = 0, valmin = 0.5)
}
\arguments{
\item{data}{containing daily precipitation time series for several gauges (one gauge time series per column)}

\item{lag}{numeric lag (expressed as number of days) used for computation for "cross" continuity ratio and joint probability of prercipitation (no)occurrence.}

\item{valmin}{threshold precipitation value [mm] for wet/dry day indicator. 
If precipitation is lower than \code{valmin}, day is considered dry. Default is 0.5 mm.}
}
\value{
A list containing the following matrices: 

\code{continuity_ratio} : \code{lag}-day lagged  continuity ratio , 

\code{occurrence}  : joint probability of \code{lag}-day lagged precipitation occurrence  

\code{nooccurrence} : joint probability of \code{lag}-day lagged no precipitation occurrence.

\code{nooccurrence_occurrence} : joint probability of \code{lag}-day lagged no precipitation and precipitation occurrence respectively.

\code{occurrence_nooccurrence} : joint probability of \code{lag}-day lagged precipitation and no precipitation occurrence respectively.

\code{probability_continuity_ratio}: \code{lag}-day lagged ratio about precipitation probability contitioned to no precipitation/preciitation occurrence in the other site
}
\description{
Calculates the continuity ratio of a set of precipitation measured or generated data in several sites as defined by Wilks, 1998 (see reference link)
}
\note{
If \code{lag==0} the function returns the continuity ratio and joint probability as described by Wilks, 1998. Otherwise the precipitation values for each couple of rain gauges are taken with \code{lag}-day lag.
}
\examples{

data(trentino)

year_min <- 1961
year_max <- 1990
origin <- paste(year_min,1,1,sep="-")

period <- PRECIPITATION$year>=year_min & PRECIPITATION$year<=year_max
station <- names(PRECIPITATION)[!(names(PRECIPITATION) \%in\% c("day","month","year"))]
prec_mes <- PRECIPITATION[period,station]  

## removing nonworking stations (e.g. time series with NA)
accepted <- array(TRUE,length(names(prec_mes)))
names(accepted) <- names(prec_mes)
for (it in names(prec_mes)) {
		 accepted[it]  <- (length(which(!is.na(prec_mes[,it])))==length(prec_mes[,it]))
}

prec_mes <- prec_mes[,accepted]
## the dateset is reduced!!! 
prec_mes <- prec_mes[,1:2]

continuity_ratio <-continuity_ratio(data=prec_mes,lag=0,valmin=0.5)
continuity_ratio1 <-continuity_ratio(data=prec_mes,lag=-1,valmin=0.5)


}
\references{
see the following URL references:  \url{http://onlinelibrary.wiley.com/doi/10.1002/joc.2305/abstract} 
  and \url{http://www.sciencedirect.com/science/article/pii/S0022169498001863}
}
