/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MonitorGraph
extends WrappedGraph {
    protected Set snapshot = new HashSet();

    public MonitorGraph(Graph g) {
        super(g);
    }

    public void snapshot(List additions, List deletions) {
        ExtendedIterator i;
        HashSet deletionsTempSet;
        boolean listening = this.getEventManager().listening();
        boolean wantAdditions = listening || additions != null;
        boolean wantDeletions = listening || deletions != null;
        List additionsTemp = additions != null ? additions : new ArrayList();
        List deletionsTemp = deletions != null ? deletions : new ArrayList();
        HashSet hashSet = deletionsTempSet = wantDeletions ? new HashSet() : null;
        if (wantAdditions || wantDeletions) {
            if (wantDeletions) {
                deletionsTempSet.addAll(this.snapshot);
            }
            i = this.base.find(Node.ANY, Node.ANY, Node.ANY);
            while (i.hasNext()) {
                Object triple = i.next();
                if (wantAdditions && !this.snapshot.contains(triple)) {
                    additionsTemp.add(triple);
                }
                if (!wantDeletions) continue;
                deletionsTempSet.remove(triple);
            }
        }
        if (deletions != null) {
            deletionsTemp.addAll(deletionsTempSet);
        }
        if (listening) {
            this.getEventManager().notifyAddList(this, additionsTemp);
            this.getEventManager().notifyDeleteList(this, deletionsTemp);
        }
        this.snapshot.clear();
        i = this.base.find(Node.ANY, Node.ANY, Node.ANY);
        while (i.hasNext()) {
            this.snapshot.add(i.next());
        }
    }
}

