/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdql.Constraint;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdql.Var;
import com.hp.hpl.jena.rdql.parser.Node;
import com.hp.hpl.jena.rdql.parser.ParsedLiteral;
import com.hp.hpl.jena.rdql.parser.Q_ConstraintClause;
import com.hp.hpl.jena.rdql.parser.Q_Identifier;
import com.hp.hpl.jena.rdql.parser.Q_PrefixDecl;
import com.hp.hpl.jena.rdql.parser.Q_PrefixesClause;
import com.hp.hpl.jena.rdql.parser.Q_SelectClause;
import com.hp.hpl.jena.rdql.parser.Q_SourceClause;
import com.hp.hpl.jena.rdql.parser.Q_TriplePattern;
import com.hp.hpl.jena.rdql.parser.Q_TriplePatternClause;
import com.hp.hpl.jena.rdql.parser.Q_URI;
import com.hp.hpl.jena.rdql.parser.Q_URL;
import com.hp.hpl.jena.rdql.parser.Q_Var;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.SimpleNode;
import java.util.Iterator;
import java.util.List;

public class Q_Query
extends SimpleNode {
    private Query query = null;
    boolean selectAllVars = false;

    public Q_Query(int id) {
        super(id);
    }

    public Q_Query(RDQLParser p, int id) {
        super(p, id);
    }

    public void phase2(Query q) {
        this.query = q;
        try {
            int numQueryChildren = this.jjtGetNumChildren();
            for (int j = 0; j < numQueryChildren; ++j) {
                Node n = this.jjtGetChild(j);
                if (!(n instanceof Q_PrefixesClause)) continue;
                this.extractPrefixes(q, (Q_PrefixesClause)n);
            }
            this.postParse(q);
            int i = 0;
            if (!(this.jjtGetChild(i) instanceof Q_SelectClause)) {
                throw new RDQL_InternalErrorException("Parser didn't catch absense of select clause");
            }
            this.extractVarList(q, this.jjtGetChild(i));
            if (this.jjtGetChild(++i) instanceof Q_SourceClause) {
                int numSources = this.jjtGetChild(i).jjtGetNumChildren();
                if (numSources > 1) {
                    throw new QueryException("Error: Multiple sources in FROM clause");
                }
                for (int j = 0; j < numSources; ++j) {
                    Node n = this.jjtGetChild(i).jjtGetChild(j).jjtGetChild(0);
                    String source = ((Q_URL)n).urlString;
                    if (j != 0) continue;
                    q.setSourceURL(source);
                }
                ++i;
            }
            if (!(this.jjtGetChild(i) instanceof Q_TriplePatternClause)) {
                throw new RDQL_InternalErrorException("Parser didn't catch absense of triple patterns");
            }
            this.extractTriplePatternsFP(q, this.jjtGetChild(i));
            if (++i < numQueryChildren && this.jjtGetChild(i) instanceof Q_ConstraintClause) {
                this.extractConstraints(q, this.jjtGetChild(i));
                ++i;
            }
        }
        catch (RDQL_InternalErrorException e) {
            throw e;
        }
        catch (QueryException qEx) {
            throw qEx;
        }
        catch (ClassCastException e) {
            throw new RDQL_InternalErrorException("Parser generated illegal parse tree: " + e);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RDQL_InternalErrorException("Unknown exception: " + e);
        }
    }

    public String toString() {
        throw new UnsupportedOperationException("Q_Query.toString()");
    }

    private void extractVarList(Query q, Node node) {
        int n = node.jjtGetNumChildren();
        this.selectAllVars = n == 0;
        for (int i = 0; i < n; ++i) {
            Node c = node.jjtGetChild(i);
            if (!(c instanceof Q_Var)) {
                throw new RDQL_InternalErrorException("Internal error: parser created '" + c.getClass().getName() + "' when Q_Var expected");
            }
            Q_Var v = (Q_Var)c;
            q.addResultVar(v.varName);
        }
    }

    private void extractTriplePatternsFP(Query q, Node node) {
        Q_TriplePatternClause tpc = (Q_TriplePatternClause)node;
        List patternVars = q.getBoundVars();
        int n = tpc.jjtGetNumChildren();
        for (int j = 0; j < n; ++j) {
            Q_TriplePattern tp = (Q_TriplePattern)tpc.jjtGetChild(j);
            if (tp.jjtGetNumChildren() != 3) {
                throw new RDQL_InternalErrorException("Triple pattern has " + tp.jjtGetNumChildren() + " children");
            }
            com.hp.hpl.jena.graph.Node nodeSubj = Q_Query.convertToGraphNode(tp.jjtGetChild(0), q);
            com.hp.hpl.jena.graph.Node nodePred = Q_Query.convertToGraphNode(tp.jjtGetChild(1), q);
            com.hp.hpl.jena.graph.Node nodeObj = Q_Query.convertToGraphNode(tp.jjtGetChild(2), q);
            q.addTriplePattern(nodeSubj, nodePred, nodeObj);
        }
        if (this.selectAllVars) {
            Iterator iter = patternVars.iterator();
            while (iter.hasNext()) {
                String varName = (String)iter.next();
                q.addResultVar(varName);
            }
        }
    }

    private static com.hp.hpl.jena.graph.Node convertToGraphNode(Node n, Query q) {
        if (n instanceof Var) {
            String varName = ((Var)((Object)n)).getVarName();
            q.addBoundVar(varName);
            return com.hp.hpl.jena.graph.Node.createVariable(((Var)((Object)n)).getVarName());
        }
        if (n instanceof ParsedLiteral) {
            ParsedLiteral v = (ParsedLiteral)n;
            if (v.isNode()) {
                return v.getNode();
            }
            if (v.isURI()) {
                return com.hp.hpl.jena.graph.Node.createURI(v.getURI());
            }
            if (v.isString()) {
                return com.hp.hpl.jena.graph.Node.createLiteral(v.getString(), null, null);
            }
            if (v.isBoolean()) {
                return com.hp.hpl.jena.graph.Node.createLiteral(v.asUnquotedString(), null, null);
            }
            if (v.isInt()) {
                return com.hp.hpl.jena.graph.Node.createLiteral(v.asUnquotedString(), null, XSDDatatype.XSDinteger);
            }
            if (v.isDouble()) {
                return com.hp.hpl.jena.graph.Node.createLiteral(v.asUnquotedString(), null, XSDDatatype.XSDdouble);
            }
            String s = v.getString();
            System.err.println("BUG: " + s);
        }
        throw new RDQL_InternalErrorException("convertToGraphNode encountered strange type: " + n.getClass().getName());
    }

    private void extractConstraints(Query q, Node node) {
        Q_ConstraintClause qcc = (Q_ConstraintClause)node;
        int n = qcc.jjtGetNumChildren();
        for (int j = 0; j < n; ++j) {
            Node obj = qcc.jjtGetChild(j);
            if (!(obj instanceof Constraint)) {
                throw new RDQL_InternalErrorException("Parse node in AND clause isn't a Constraint");
            }
            q.addConstraint((Constraint)((Object)obj));
        }
    }

    private void extractPrefixes(Query q, Q_PrefixesClause qns) {
        if (qns == null) {
            return;
        }
        int n = qns.jjtGetNumChildren();
        for (int j = 0; j < n; ++j) {
            Q_PrefixDecl qnsd = (Q_PrefixDecl)qns.jjtGetChild(j);
            for (int k = 0; k < qnsd.jjtGetNumChildren(); k += 2) {
                Q_Identifier id = (Q_Identifier)qnsd.jjtGetChild(k);
                Q_URI uri = (Q_URI)qnsd.jjtGetChild(k + 1);
                this.query.setPrefix(id.toString(), uri.toString());
            }
        }
    }
}

