% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset06}
\alias{dataset06}
\title{Magnus FROC dataset}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1:2, 1:4, 1:89, 1:17], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1:2, 1:4, 1:42, 1:15], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:42], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:42, 1:15], numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:42, 1:15], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "dataset06", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "FROC", the data type}
\item{\code{descriptions$name}}{, chr "MAGNUS", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, num [1:2, 1:4, 1:89, 1:16], truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr [1:2] "1" "2", treatment labels}
\item{\code{descriptions$readerID}}{, chr [1:4] "1" "2" "3" "4", reader labels}
}
}
\usage{
dataset06
}
\description{
This is referred to in the book as the "MAG" dataset (after Magnus Bath, 
who conducted the JAFROC analysis). It consists of 100 cases, 69 of which are diseased, 
interpreted in two treatments ("1" = conventional chest, "1" = chest tomosynthesis) by four 
radiologists using the FROC paradigm.
}
\examples{
str(dataset06)
PlotEmpiricalOperatingCharacteristics(dataset = dataset06, opChType = "wAFROC")$Plot


}
\references{
Vikgren J  et al. Comparison of Chest Tomosynthesis and Chest Radiography 
for Detection of Pulmonary Nodules: Human Observer Study of Clinical Cases. 
Radiology. 2008;249(3):1034-1041.
}
\keyword{datasets}
