% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilAucCBM.R
\name{UtilAucCBM}
\alias{UtilAucCBM}
\title{CBM AUC function}
\usage{
UtilAucCBM(mu, alpha)
}
\arguments{
\item{mu}{The \code{mu} parameter of CBM (separation of non-diseased 
and diseased pdfs)}

\item{alpha}{The \code{alpha} parameter of CBM, i.e., the fraction 
of diseased cases on which the disease is visible}
}
\value{
CBM-predicted ROC-AUC for the specified parameters
}
\description{
{Returns the CBM ROC-AUC
See also \code{\link{UtilAnalyticalAucsRSM}}, \code{\link{UtilAucPROPROC}} and \code{\link{UtilAucBinormal}}}
}
\examples{
mu <- 2;alpha <- 0.8
UtilAucCBM(mu,alpha)


}
\references{
Dorfman DD, Berbaum KS (2000) A contaminated binormal model for ROC data: Part II. 
A formal model, Acad Radiol 7:6 427--437.
}
