/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.helper.QueryPanel;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class QueryContentFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Configuration.getSdmxLogger();

    public QueryContentFrame(List<PortableTimeSeries> list) {
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getContentPane());
        JScrollPane jScrollPane = new JScrollPane();
        int n = list.size();
        if (n > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("Time Series");
            PortableTimeSeries portableTimeSeries = list.get(0);
            List<String> list2 = portableTimeSeries.getDimensions();
            String string = "[ =]";
            for (String object : list2) {
                String[] n3 = object.split(string);
                String n4 = n3[0] + " (" + n3[1] + ")";
                arrayList.add(n4);
            }
            int n2 = arrayList.size();
            if (n2 > 0) {
                DefaultTableModel defaultTableModel = new DefaultTableModel();
                defaultTableModel.setColumnCount(n2);
                defaultTableModel.setColumnIdentifiers(arrayList.toArray());
                defaultTableModel.setNumRows(n);
                int n3 = 0;
                int n4 = 1;
                for (PortableTimeSeries portableTimeSeries2 : list) {
                    List<String> list3 = portableTimeSeries2.getDimensions();
                    defaultTableModel.setValueAt(portableTimeSeries2.getName(), n3, 0);
                    n4 = 1;
                    for (String string2 : list3) {
                        String[] stringArray = string2.split(string);
                        String string3 = stringArray[0];
                        String string4 = stringArray[1];
                        try {
                            String sdmxException = SdmxClientHandler.getCodes(QueryPanel.selectedProvider, QueryPanel.selectedDataflow, string3).get(string4);
                            defaultTableModel.setValueAt(string4 + " (" + sdmxException + ")", n3, n4);
                        }
                        catch (SdmxException sdmxException) {
                            logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
                            logger.log(Level.FINER, "", sdmxException);
                        }
                        ++n4;
                    }
                    ++n3;
                }
                JTable jTable = new JTable(defaultTableModel);
                jTable.setAutoCreateRowSorter(true);
                jScrollPane.getViewport().add(jTable);
                this.add(jScrollPane);
            }
        }
    }
}

