/*
 * Decompiled with CFR 0.152.
 */
package jd2.xml.calendar;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.calendars.ChainedGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.utilities.StringFormatter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import jd2.xml.calendar.AbstractXmlCalendar;

@XmlRootElement(name="chainedCalendar")
@XmlType(name="chainedCalendarType")
public class XmlChainedCalendar
extends AbstractXmlCalendar {
    static final String NAME = "chainedCalendarType";
    @XmlElement
    public String startCalendar;
    @XmlElement
    public String endCalendar;
    @XmlElement
    public String calendarBreak;

    public static XmlChainedCalendar create(String code, GregorianCalendarManager mgr) {
        IGregorianCalendarProvider cal = (IGregorianCalendarProvider)mgr.get(code);
        if (cal == null || !(cal instanceof ChainedGregorianCalendarProvider)) {
            return null;
        }
        ChainedGregorianCalendarProvider t = (ChainedGregorianCalendarProvider)cal;
        XmlChainedCalendar xcal = new XmlChainedCalendar();
        xcal.startCalendar = t.first;
        xcal.endCalendar = t.second;
        xcal.calendarBreak = StringFormatter.convert((Day)t.breakDay);
        xcal.name = code;
        return xcal;
    }

    @Override
    public boolean addTo(GregorianCalendarManager mgr) {
        ChainedGregorianCalendarProvider ccp = new ChainedGregorianCalendarProvider(mgr, this.startCalendar, StringFormatter.convertDay((String)this.calendarBreak), this.endCalendar);
        if (this.name != null) {
            mgr.set(this.name, (Object)ccp);
            return true;
        }
        return false;
    }
}

