/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ucarima.estimation;

import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.arima.estimation.AnsleyFilter;
import ec.tstoolkit.arima.estimation.IArmaFilter;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.ElementaryTransformations;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.RationalFunction;
import ec.tstoolkit.ucarima.UcarimaModel;

public class McElroyEstimates {
    private UcarimaModel ucm_;
    private double[] data_;
    private Matrix[] M_;
    private Matrix[] F_;
    private Matrix[] L_;
    private Matrix[] K_;
    private Matrix[] D_;
    private double[][] cmps_;
    private double[][] fcmps_;
    private int nf_;
    private IArmaFilter[] filters_;

    private void clear() {
        this.M_ = null;
        this.F_ = null;
        this.L_ = null;
        this.K_ = null;
        this.cmps_ = null;
        this.filters_ = null;
        this.D_ = null;
        this.fcmps_ = null;
    }

    public UcarimaModel getUcarimaModel() {
        return this.ucm_;
    }

    public void setUcarimaModel(UcarimaModel ucm) {
        this.ucm_ = ucm;
        this.clear();
    }

    public void setData(IReadDataBlock data) {
        this.data_ = new double[data.getLength()];
        data.copyTo(this.data_, 0);
        this.clear();
    }

    public void setData(double[] data) {
        this.data_ = data;
        this.clear();
    }

    public double[] getData() {
        return this.data_;
    }

    public int getForecastsCount() {
        return this.nf_;
    }

    public void setForecastsCount(int nf) {
        if (nf != this.nf_) {
            this.nf_ = nf;
            this.D_ = null;
            this.fcmps_ = null;
        }
    }

    public double[] getComponent(int cmp) {
        this.calc(cmp);
        return this.cmps_[cmp];
    }

    public double[] getForecasts(int cmp) {
        this.fcalc(cmp);
        return this.fcmps_[cmp];
    }

    public double[] getForecasts() {
        int n = this.ucm_.getComponentsCount();
        this.fcalc(n);
        return this.fcmps_[n];
    }

    public double[] stdevForecasts() {
        int n = this.ucm_.getComponentsCount();
        return this.stdevForecasts(n);
    }

    public double[] stdevForecasts(int cmp) {
        this.fcalc(cmp);
        Matrix m = this.D_[cmp];
        DataBlock var = m.diagonal();
        double[] e = new double[var.getLength()];
        var.copyTo(e, 0);
        for (int i = 0; i < e.length; ++i) {
            e[i] = Math.sqrt(e[i]);
        }
        return e;
    }

    public double[] stdevEstimates(int cmp) {
        Matrix m = this.M(cmp);
        DataBlock var = m.diagonal();
        double[] e = new double[var.getLength()];
        var.copyTo(e, 0);
        for (int i = 0; i < e.length; ++i) {
            e[i] = Math.sqrt(e[i]);
        }
        return e;
    }

    public Matrix M(int cmp) {
        this.calc(cmp);
        if (this.M_[cmp] == null) {
            Matrix L = this.L_[cmp];
            if (L == null) {
                return null;
            }
            Matrix I = Matrix.identity(L.getColumnsCount());
            LowerTriangularMatrix.rsolve(L, I.subMatrix());
            LowerTriangularMatrix.lsolve(L, I.subMatrix().transpose());
            this.M_[cmp] = I;
        }
        return this.M_[cmp];
    }

    public Matrix F(int cmp) {
        this.calc(cmp);
        if (this.F_[cmp] == null) {
            Matrix L = this.L_[cmp];
            Matrix K = this.K_[cmp];
            if (L == null || K == null) {
                return null;
            }
            Matrix KK = SymmetricMatrix.XtX(K);
            LowerTriangularMatrix.rsolve(L, KK.subMatrix());
            LowerTriangularMatrix.lsolve(L, KK.subMatrix().transpose());
            this.F_[cmp] = KK;
        }
        return this.F_[cmp];
    }

    private void calc(int cmp) {
        int i;
        DataBlock d;
        int j;
        if (this.data_ == null || this.ucm_ == null) {
            return;
        }
        if (this.M_ == null) {
            int ncmps = this.ucm_.getComponentsCount();
            this.K_ = new Matrix[ncmps];
            this.L_ = new Matrix[ncmps];
            this.M_ = new Matrix[ncmps];
            this.F_ = new Matrix[ncmps];
            this.cmps_ = new double[ncmps][];
            this.filters_ = new IArmaFilter[ncmps + 1];
        } else if (this.cmps_[cmp] != null) {
            return;
        }
        ArimaModel signal = this.ucm_.getComponent(cmp);
        if (signal.isNull()) {
            return;
        }
        ArimaModel noise = this.ucm_.getComplement(cmp);
        int n = this.data_.length;
        StationaryTransformation stS = signal.stationaryTransformation();
        StationaryTransformation stN = noise.stationaryTransformation();
        Polynomial ds = stS.unitRoots.getPolynomial();
        Polynomial dn = stN.unitRoots.getPolynomial();
        Matrix DS = new Matrix(n - ds.getDegree(), n);
        Matrix DN = new Matrix(n - dn.getDegree(), n);
        double[] c = ds.getCoefficients();
        for (j = 0; j < c.length; ++j) {
            d = DS.subDiagonal(j);
            d.set(c[c.length - j - 1]);
        }
        c = dn.getCoefficients();
        for (j = 0; j < c.length; ++j) {
            d = DN.subDiagonal(j);
            d.set(c[c.length - j - 1]);
        }
        AnsleyFilter S = new AnsleyFilter();
        S.initialize((IArimaModel)stS.stationaryModel, n - ds.getDegree());
        this.filters_[cmp] = S;
        AnsleyFilter N = new AnsleyFilter();
        N.initialize((IArimaModel)stN.stationaryModel, n - dn.getDegree());
        Matrix Q = new Matrix(n, 2 * n - ds.getDegree() - dn.getDegree());
        for (i = 0; i < n; ++i) {
            S.filter(DS.column(i), Q.row(n - i - 1).range(0, n - ds.getDegree()));
        }
        for (i = 0; i < n; ++i) {
            N.filter(DN.column(i), Q.row(n - i - 1).drop(n - ds.getDegree(), 0));
        }
        this.K_[cmp] = new Matrix(Q.subMatrix(0, n, n - ds.getDegree(), Q.getColumnsCount()));
        DataBlock yd = new DataBlock(n - dn.getDegree());
        noise.getNonStationaryAR().filter(new DataBlock(this.data_), yd);
        DataBlock yl = new DataBlock(yd.getLength());
        N.filter(yd, yl);
        double[] z = new double[n];
        int i2 = 0;
        int j2 = n - 1;
        while (i2 < n) {
            z[i2] = Q.row(j2).drop(n - ds.getDegree(), 0).dot(yl);
            ++i2;
            --j2;
        }
        ElementaryTransformations.fastGivensTriangularize(Q.subMatrix());
        Matrix L = new Matrix(Q.subMatrix(0, n, 0, n));
        LowerTriangularMatrix.rsolve(L, z);
        LowerTriangularMatrix.lsolve(L, z);
        this.L_[cmp] = L;
        this.cmps_[cmp] = z;
    }

    private IArmaFilter seriesFilter() {
        int n = this.data_.length;
        IArimaModel model = this.ucm_.getModel();
        StationaryTransformation stm = model.stationaryTransformation();
        AnsleyFilter F2 = new AnsleyFilter();
        F2.initialize((IArimaModel)stm.stationaryModel, n - stm.unitRoots.getDegree());
        return F2;
    }

    private void fcalc(int cmp) {
        Matrix D;
        IArimaModel signal;
        boolean fs;
        int ncmps = this.ucm_.getComponentsCount();
        boolean bl = fs = cmp == ncmps;
        if (!fs) {
            this.calc(cmp);
        }
        if (this.fcmps_ == null) {
            this.fcmps_ = new double[ncmps + 1][];
            this.D_ = new Matrix[ncmps + 1];
        } else if (this.fcmps_[cmp] != null) {
            return;
        }
        if (fs) {
            if (this.filters_ == null) {
                this.filters_ = new IArmaFilter[ncmps + 1];
            }
            if (this.filters_[cmp] == null) {
                this.filters_[cmp] = this.seriesFilter();
            }
        }
        int n = this.data_.length;
        IArimaModel iArimaModel = signal = fs ? this.ucm_.getModel() : this.ucm_.getComponent(cmp);
        if (signal.isNull()) {
            return;
        }
        StationaryTransformation stS = signal.stationaryTransformation();
        Polynomial ds = stS.unitRoots.getPolynomial();
        Matrix DS = new Matrix(n - ds.getDegree(), n);
        double[] c = ds.getCoefficients();
        for (int j = 0; j < c.length; ++j) {
            DataBlock d = DS.subDiagonal(j);
            d.set(c[c.length - j - 1]);
        }
        Matrix Q = new Matrix(n - ds.getDegree(), n);
        for (int i = 0; i < n; ++i) {
            this.filters_[cmp].filter(DS.column(i), Q.column(i));
        }
        Matrix U = new Matrix(n - ds.getDegree(), this.nf_);
        double[] acf = stS.stationaryModel.getAutoCovarianceFunction().values(n - ds.getDegree() + this.nf_);
        for (int i = 0; i < this.nf_; ++i) {
            U.column(i).reverse().copyFrom(acf, i + 1);
        }
        Matrix V = new Matrix(this.nf_, n - ds.getDegree());
        for (int i = 0; i < this.nf_; ++i) {
            if (U.column(i).isZero()) continue;
            this.filters_[cmp].filter(U.column(i), V.row(i));
        }
        Matrix W = V.times(Q);
        if (ds.getDegree() > 0) {
            D = new Matrix(ds.getDegree() + this.nf_, n);
            D.subDiagonal(n - ds.getDegree()).set(1.0);
            D.subMatrix(ds.getDegree(), D.getRowsCount(), 0, n).copy(W.subMatrix());
            Matrix S = new Matrix(ds.getDegree() + this.nf_, ds.getDegree() + this.nf_);
            S.diagonal().set(1.0);
            for (int i = 1; i <= ds.getDegree(); ++i) {
                S.subDiagonal(-i).drop(ds.getDegree() - i, 0).set(ds.get(i));
            }
            LowerTriangularMatrix.rsolve(S, D.subMatrix());
            D = new Matrix(D.subMatrix(ds.getDegree(), D.getRowsCount(), 0, n));
        } else {
            D = W;
        }
        DataBlock f = new DataBlock(this.nf_);
        double[] data = fs ? this.data_ : this.getComponent(cmp);
        f.product(D.rows(), new DataBlock(data));
        this.fcmps_[cmp] = f.getData();
        Matrix G = SymmetricMatrix.XXt(V);
        G.chs();
        G.diagonal().add(acf[0]);
        for (int i = 1; i < this.nf_; ++i) {
            G.subDiagonal(i).add(acf[i]);
            G.subDiagonal(-i).add(acf[i]);
        }
        if (ds.getDegree() > 0) {
            Matrix B = new Matrix(this.nf_, this.nf_);
            RationalFunction rfe = new RationalFunction(Polynomial.ONE, ds);
            double[] coeff = rfe.coefficients(this.nf_);
            for (int i = 0; i < this.nf_; ++i) {
                B.subDiagonal(-i).set(coeff[i]);
            }
            G = SymmetricMatrix.quadraticFormT(G, B);
        }
        if (!fs) {
            Matrix m = this.M(cmp);
            m = SymmetricMatrix.quadraticFormT(m, D);
            G.add(m);
        }
        this.D_[cmp] = G;
    }
}

