/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.calendars;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.DayOfWeek;
import ec.tstoolkit.timeseries.Month;
import ec.tstoolkit.timeseries.calendars.IDayInfo;
import ec.tstoolkit.timeseries.calendars.ISpecialDay;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.Iterator;
import java.util.Objects;

public class FixedDay
implements ISpecialDay {
    public final int day;
    public final Month month;
    private final double weight;
    public static final FixedDay Christmas = new FixedDay(24, Month.December);
    public static final FixedDay NewYear = new FixedDay(0, Month.January);
    public static final FixedDay Assumption = new FixedDay(14, Month.August);
    public static final FixedDay MayDay = new FixedDay(0, Month.May);
    public static final FixedDay AllSaintsDay = new FixedDay(0, Month.November);
    public static final FixedDay Halloween = new FixedDay(30, Month.October);

    public FixedDay(int day, Month month) {
        this(day, month, 1.0);
    }

    public FixedDay(int day, Month month, double weight) {
        this.day = day;
        this.month = month;
        this.weight = weight;
    }

    public FixedDay reweight(double nweight) {
        if (this.weight == this.weight) {
            return this;
        }
        return new FixedDay(this.day, this.month, nweight);
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public boolean match(ISpecialDay.Context context) {
        return true;
    }

    public Day calcDay(int year) {
        return new Day(year, this.month, this.day);
    }

    @Override
    public Iterable<IDayInfo> getIterable(TsFrequency freq, Day start, Day end) {
        return new FixedDayIterable(freq, this, start, end);
    }

    @Override
    public double[][] getLongTermMeanEffect(int freq) {
        int c = 12 / freq;
        int imonth = this.month.intValue();
        int p = imonth / c;
        double[] m = new double[7];
        for (int i = 0; i < 6; ++i) {
            m[i] = this.weight / 7.0;
        }
        m[6] = -this.weight * 6.0 / 7.0;
        double[][] rslt = new double[freq][];
        rslt[p] = m;
        return rslt;
    }

    public FixedDay plus(int offset) {
        if (offset == 0) {
            return this;
        }
        int imonth = this.month.intValue();
        int pos = Day.getCumulatedMonthDays(imonth) + this.day;
        if ((pos += offset) < 0 || pos >= 365) {
            return null;
        }
        int nmonth = 0;
        while (pos >= Day.getCumulatedMonthDays(nmonth + 1)) {
            ++nmonth;
        }
        int nday = pos - Day.getCumulatedMonthDays(nmonth);
        if (imonth <= 1 && nmonth >= 2) {
            return null;
        }
        return new FixedDay(nday, Month.valueOf(nmonth), this.weight);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof FixedDay && this.equals((FixedDay)obj);
    }

    private boolean equals(FixedDay other) {
        return other.day == this.day && other.month == this.month && other.weight == this.weight;
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + this.day;
        hash = 31 * hash + Objects.hashCode(this.month);
        return hash;
    }

    @Override
    public TsDomain getSignificantDomain(TsFrequency freq, Day start, Day end) {
        Day eday;
        TsPeriod pstart = new TsPeriod(freq, start);
        TsPeriod pend = new TsPeriod(freq, end);
        Day sday = new Day(pstart.getYear(), this.month, this.day);
        if (start.isAfter(sday)) {
            pstart.move(1);
        }
        if (end.isBefore(eday = new Day(pend.getYear(), this.month, this.day))) {
            pend.move(-1);
        }
        int n = pend.minus(pstart) + 1;
        return new TsDomain(pstart, Math.max(0, n));
    }

    static class FixedDayIterable
    implements Iterable<IDayInfo> {
        private final FixedDay fday;
        private final TsPeriod pstart;
        private final int m_n;

        FixedDayIterable(TsFrequency freq, FixedDay fday, Day fstart, Day fend) {
            this.fday = fday;
            int ystart = fstart.getYear();
            int yend = fend.getYear();
            Day xday = new Day(ystart, fday.month, fday.day);
            Day yday = new Day(yend, fday.month, fday.day);
            this.pstart = new TsPeriod(freq);
            this.pstart.set(xday);
            TsPeriod pend = new TsPeriod(freq);
            pend.set(yday);
            if (xday.isNotBefore(fstart)) {
                this.pstart.move(-freq.intValue());
            }
            if (yday.isAfter(fend)) {
                pend.move(-freq.intValue());
            }
            this.m_n = pend.getYear() - this.pstart.getYear();
        }

        @Override
        public Iterator<IDayInfo> iterator() {
            return new Iterator<IDayInfo>(){
                FixedDayInfo m_info;
                int m_cur;
                {
                    this.m_info = new FixedDayInfo(pstart, fday);
                    this.m_cur = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.m_cur < m_n - 1;
                }

                @Override
                public IDayInfo next() {
                    this.m_info.move(1);
                    ++this.m_cur;
                    return this.m_info;
                }
            };
        }
    }

    static class FixedDayInfo
    implements IDayInfo {
        final TsPeriod m_period;
        final FixedDay m_fday;

        FixedDayInfo(TsPeriod period, FixedDay fday) {
            this.m_fday = fday;
            this.m_period = period.clone();
        }

        @Override
        public Day getDay() {
            return new Day(this.m_period.getYear(), this.m_fday.month, this.m_fday.day);
        }

        @Override
        public TsPeriod getPeriod() {
            return this.m_period;
        }

        @Override
        public DayOfWeek getDayOfWeek() {
            return this.getDay().getDayOfWeek();
        }

        public void move(int n) {
            this.m_period.move(n * this.m_period.getFrequency().intValue());
        }
    }
}

