/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.eco.Determinant;

public class ResidualsCumulator {
    Determinant m_det = new Determinant();
    double m_ssqerr;
    int m_n;

    public void add(double e, double var) {
        if (Math.abs(var) < 1.0E-6 && Math.abs(e) < 1.0E-6) {
            return;
        }
        this.m_det.add(var);
        this.m_ssqerr += e * e / var;
        ++this.m_n;
    }

    public void clear() {
        this.m_ssqerr = 0.0;
        this.m_det.clear();
        this.m_n = 0;
    }

    public double getLogDeterminant() {
        return this.m_det.getLogDeterminant();
    }

    public int getObsCount() {
        return this.m_n;
    }

    public double getSsqErr() {
        return this.m_ssqerr;
    }
}

