/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.random;

import ec.tstoolkit.random.IRandomNumberGenerator;

public abstract class AbstractRNG
implements IRandomNumberGenerator {
    private static final double IntToDoubleMultiplier = 4.656612873077393E-10;

    @Override
    public double nextDouble() {
        return (double)(this.nextInt() >>> 1) * 4.656612873077393E-10;
    }

    @Override
    public long nextLong() {
        return ((long)this.nextInt() & 0xFFFFFFFFL) << 32 | (long)this.nextInt() & 0xFFFFFFFFL;
    }

    @Override
    public boolean nextBoolean() {
        return this.nextInt() % 2 != 0;
    }

    @Override
    public float nextFloat() {
        return (float)this.nextDouble();
    }

    @Override
    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int result = (int)(this.nextDouble() * (double)n);
        return result < n ? result : n - 1;
    }

    @Override
    public IRandomNumberGenerator synchronize() {
        return new SynchronizedRNG(this);
    }

    private static final class SynchronizedRNG
    implements IRandomNumberGenerator {
        private final IRandomNumberGenerator rng;

        private SynchronizedRNG(IRandomNumberGenerator rng) {
            this.rng = rng;
        }

        @Override
        public synchronized double nextDouble() {
            return this.rng.nextDouble();
        }

        @Override
        public synchronized int nextInt() {
            return this.rng.nextInt();
        }

        @Override
        public synchronized long nextLong() {
            return this.rng.nextLong();
        }

        @Override
        public synchronized boolean nextBoolean() {
            return this.rng.nextBoolean();
        }

        @Override
        public synchronized float nextFloat() {
            return this.rng.nextFloat();
        }

        @Override
        public synchronized int nextInt(int n) throws IllegalArgumentException {
            return this.rng.nextInt(n);
        }

        @Override
        public IRandomNumberGenerator synchronize() {
            return this;
        }
    }
}

