/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

import ec.tstoolkit.eco.ILikelihood;

public class DiffuseLikelihood
implements ILikelihood {
    private double m_ll;
    private double m_ssqerr;
    private double m_ldet;
    private double m_lddet;
    private int m_n;
    private int m_d;
    private double[] m_res;

    public double AIC(int nparams) {
        return -2.0 * this.getUncorrectedLogLikelihood() + (double)(2 * nparams);
    }

    public double BIC(int nparams) {
        return -2.0 * this.getUncorrectedLogLikelihood() + (double)nparams * Math.log(this.m_n - this.m_d);
    }

    public void clear() {
        this.m_ll = 0.0;
        this.m_ssqerr = 0.0;
        this.m_ldet = 0.0;
        this.m_lddet = 0.0;
        this.m_n = 0;
        this.m_d = 0;
    }

    public int getD() {
        return this.m_d;
    }

    @Override
    public double getFactor() {
        return Math.exp((this.m_ldet + this.m_lddet) / (double)(this.m_n - this.m_d));
    }

    @Override
    public double getLogLikelihood() {
        return this.m_ll;
    }

    @Override
    public int getN() {
        return this.m_n;
    }

    @Override
    public double[] getResiduals() {
        return this.m_res;
    }

    @Override
    public double getLogDeterminant() {
        return this.m_ldet;
    }

    public double getDiffuseLogDeterminant() {
        return this.m_lddet;
    }

    public double getUncorrectedLogLikelihood() {
        return this.m_ll - this.getDiffuseCorrection();
    }

    public double getSer() {
        return Math.sqrt(this.m_ssqerr / (double)(this.m_n - this.m_d));
    }

    @Override
    public double getSigma() {
        return this.m_ssqerr / (double)(this.m_n - this.m_d);
    }

    @Override
    public double getSsqErr() {
        return this.m_ssqerr;
    }

    public void rescale(double factor) {
        if (factor == 1.0) {
            return;
        }
        this.m_ssqerr /= factor * factor;
        this.m_ll += (double)(this.m_n - this.m_d) * Math.log(factor);
        if (this.m_res != null) {
            int i = 0;
            while (i < this.m_res.length) {
                int n = i++;
                this.m_res[n] = this.m_res[n] / factor;
            }
        }
    }

    public double getDiffuseCorrection() {
        return -0.5 * (this.m_lddet + (double)this.m_d * Math.log(Math.PI * 2));
    }

    public void set(double ssqerr, double ldet, double lddet, int n, int d) {
        this.m_ll = -0.5 * ((double)n * Math.log(Math.PI * 2) + (double)(n - d) * (1.0 + Math.log(ssqerr / (double)(n - d))) + ldet + lddet);
        this.m_ssqerr = ssqerr;
        this.m_ldet = ldet;
        this.m_lddet = lddet;
        this.m_n = n;
        this.m_d = d;
        this.m_res = null;
    }

    public void setRes(double[] res) {
        this.m_res = (double[])(res != null ? (double[])res.clone() : null);
    }
}

