/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;

public class BurgAlgorithm {
    private double[] x;
    private double[] a;

    public boolean solve(IReadDataBlock x, int m) {
        this.x = new double[x.getLength()];
        x.copyTo(this.x, 0);
        return this.calc(m);
    }

    public IReadDataBlock getCoefficients() {
        return new ReadDataBlock(this.a);
    }

    public double[] residuals() {
        int n = this.x.length;
        double[] res = new double[n];
        for (int i = 0; i < n; ++i) {
            double e = this.x[i];
            int jmax = this.a.length > i ? i : this.a.length;
            for (int j = 1; j <= jmax; ++j) {
                e += this.a[j - 1] * this.x[i - j];
            }
            res[i] = e;
        }
        return res;
    }

    private boolean calc(int m) {
        int n = this.x.length - 1;
        double[] ak = new double[m + 1];
        ak[0] = 1.0;
        double[] f = (double[])this.x.clone();
        double[] b = (double[])this.x.clone();
        double dk = 0.0;
        for (int j = 0; j <= n; ++j) {
            dk += 2.0 * f[j] * f[j];
        }
        dk -= f[0] * f[0] + b[n] * b[n];
        for (int k = 0; k < m; ++k) {
            double t2;
            double t1;
            int l;
            double mu = 0.0;
            for (l = 0; l <= n - k - 1; ++l) {
                mu += f[l + k + 1] * b[l];
            }
            mu *= -2.0 / dk;
            for (l = 0; l <= (k + 1) / 2; ++l) {
                t1 = ak[l] + mu * ak[k + 1 - l];
                t2 = ak[k + 1 - l] + mu * ak[l];
                ak[l] = t1;
                ak[k + 1 - l] = t2;
            }
            for (l = 0; l <= n - k - 1; ++l) {
                t1 = f[l + k + 1] + mu * b[l];
                t2 = b[l] + mu * f[l + k + 1];
                f[l + k + 1] = t1;
                b[l] = t2;
            }
            dk = (1.0 - mu * mu) * dk - f[k + 1] * f[k + 1] - b[n - k - 1] * b[n - k - 1];
        }
        this.a = new double[m];
        System.arraycopy(ak, 1, this.a, 0, m);
        return true;
    }
}

