/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.design.Algorithm;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFrequencyResponse;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.realfunctions.GridSearch;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IParametersDomain;
import ec.tstoolkit.maths.realfunctions.NumericalDerivatives;
import ec.tstoolkit.maths.realfunctions.ParametersRange;
import ec.tstoolkit.maths.realfunctions.SingleParameter;
import ec.tstoolkit.maths.realfunctions.bfgs.Bfgs;

public class Spectrum {
    private static final double g_epsilon = 1.0E-7;
    private static final double g_epsilon2 = 1.0E-9;
    private static final double TWOPI = Math.PI * 2;
    private SymmetricFilter m_num;
    private SymmetricFilter m_denom;

    public Spectrum() {
    }

    public Spectrum(SymmetricFilter num, SymmetricFilter denom) {
        this.m_num = num;
        this.m_denom = denom;
    }

    public double get(double freq) {
        double val = Spectrum.value(this, freq);
        if (val < 0.0) {
            return 0.0;
        }
        if (Double.isNaN(val)) {
            return Double.POSITIVE_INFINITY;
        }
        return val / (Math.PI * 2);
    }

    static double value(Spectrum s, double x) {
        double d = s.m_denom.frequencyResponse(x).getRe();
        double n = s.m_num.frequencyResponse(x).getRe();
        if (Math.abs(d) > 1.0E-9) {
            return n / d;
        }
        if (Math.abs(n) < 1.0E-7) {
            for (int i = 1; i <= 10; ++i) {
                double dd = new dfr(s.m_denom, i).evaluate(x);
                double nd = new dfr(s.m_num, i).evaluate(x);
                if (Math.abs(dd) > 1.0E-9) {
                    return nd / dd;
                }
                if (Math.abs(nd) > 1.0E-7) break;
            }
        }
        return Double.NaN;
    }

    public SymmetricFilter getDenominator() {
        return this.m_denom;
    }

    public SymmetricFilter getNumerator() {
        return this.m_num;
    }

    private static class dfr {
        final int d;
        final SymmetricFilter filter;

        dfr(SymmetricFilter filter, int d) {
            this.filter = filter;
            this.d = d;
        }

        double evaluate(double freq) {
            if (this.d % 2 == 0) {
                double s = 0.0;
                for (int i = 1; i <= this.filter.getDegree(); ++i) {
                    double c = i;
                    for (int j = 1; j < this.d; ++j) {
                        c *= (double)i;
                    }
                    s += (c *= Math.cos(freq * (double)i) * this.filter.getWeight(i));
                }
                return s;
            }
            double s = 0.0;
            for (int i = 1; i <= this.filter.getDegree(); ++i) {
                double c = i;
                for (int j = 1; j < this.d; ++j) {
                    c *= (double)i;
                }
                s += (c *= Math.sin(freq * (double)i) * this.filter.getWeight(i));
            }
            return s;
        }
    }

    @Algorithm(entryPoint="minimize")
    public static class Minimizer {
        private double m_min;
        private double m_x;
        private static final int MIN_DEG = 8;

        public double getMinimum() {
            return this.m_min;
        }

        public double getMinimumFrequency() {
            return this.m_x;
        }

        public void minimize(Spectrum spectrum) {
            int nd = spectrum.m_num.getDegree() + spectrum.m_denom.getDegree();
            if (nd <= 8) {
                this.minimize2(spectrum);
                return;
            }
            this.m_x = 0.0;
            this.m_min = Double.MAX_VALUE;
            double y = Spectrum.value(spectrum, 0.0);
            if (!Double.isNaN(y)) {
                this.m_min = y;
                this.m_x = 0.0;
            }
            if (!Double.isNaN(y = Spectrum.value(spectrum, Math.PI)) && y < this.m_min) {
                this.m_min = y;
                this.m_x = Math.PI;
            }
            GridSearch search = new GridSearch();
            search.setBounds(0.0, Math.PI);
            search.setMaxIter(1000);
            search.setInitialGridCount(4 * nd - 1);
            search.setConvergenceCriterion(1.0E-9);
            search.setPrecision(1.0E-7);
            if (search.minimize(new SpectrumFunction(spectrum), new SpectrumFunctionInstance(spectrum, 0.1))) {
                SpectrumFunctionInstance fmin = (SpectrumFunctionInstance)search.getResult();
                double min = fmin.getValue();
                if (min < this.m_min) {
                    this.m_min = min;
                    this.m_x = fmin.pt;
                }
            } else {
                this.minimize2(spectrum);
            }
        }

        @Deprecated
        public void minimize1(Spectrum spectrum) {
            double b;
            this.m_x = 0.0;
            this.m_min = Double.MAX_VALUE;
            double y = Spectrum.value(spectrum, 0.0);
            if (!Double.isNaN(y)) {
                this.m_min = y;
                this.m_x = 0.0;
            }
            if (!Double.isNaN(y = Spectrum.value(spectrum, Math.PI)) && y < this.m_min) {
                this.m_min = y;
                this.m_x = Math.PI;
            }
            int nd = spectrum.m_num.getDegree() + spectrum.m_denom.getDegree();
            int imin = -1;
            double smin = 0.0;
            double step = Math.PI / (double)(nd *= 4);
            for (int i = 0; i <= nd; ++i) {
                double cur = Spectrum.value(spectrum, (double)i * step);
                if (Double.isNaN(cur) || imin != -1 && !(cur < smin)) continue;
                imin = i;
                smin = cur;
            }
            Bfgs bfgs = new Bfgs();
            double a = imin == 0 ? 0.0 : (double)(imin - 1) * step;
            if (bfgs.minimize((IFunction)new SpectrumFunction(spectrum, a, b = imin == nd ? Math.PI : (double)(imin + 1) * step), new SpectrumFunctionInstance(spectrum, (double)imin * step))) {
                SpectrumFunctionInstance fmin = (SpectrumFunctionInstance)bfgs.getResult();
                double min = fmin.getValue();
                if (min < this.m_min) {
                    this.m_min = min;
                    this.m_x = fmin.pt;
                }
            } else {
                this.minimize(spectrum);
            }
        }

        @Deprecated
        public void minimize2(Spectrum spectrum) {
            Polynomial r;
            Complex[] roots;
            SymmetricFrequencyResponse fnum = new SymmetricFrequencyResponse(spectrum.m_num);
            SymmetricFrequencyResponse fdenom = new SymmetricFrequencyResponse(spectrum.m_denom);
            double scale = fdenom.getIntegral();
            Polynomial num = fnum.getPolynomial().divide(scale).adjustDegree();
            Polynomial denom = fdenom.getPolynomial().divide(scale).adjustDegree();
            if (num.isZero()) {
                this.m_min = 0.0;
                this.m_x = 0.0;
                return;
            }
            if (num.getDegree() == 0 && denom.getDegree() == 0) {
                this.m_min = num.get(0) / denom.get(0);
                this.m_x = 0.0;
                return;
            }
            this.m_x = 0.0;
            this.m_min = Double.MAX_VALUE;
            double y = this.evaluate(num, denom, 0.0);
            if (!Double.isNaN(y)) {
                this.m_min = y;
                this.m_x = 1.5707963267948966;
            }
            if (!Double.isNaN(y = this.evaluate(num, denom, 1.0)) && y < this.m_min) {
                this.m_min = y;
                this.m_x = 0.0;
            }
            if (!Double.isNaN(y = this.evaluate(num, denom, -1.0)) && y < this.m_min) {
                this.m_min = y;
                this.m_x = Math.PI;
            }
            if ((roots = (r = denom.getDegree() > 0 ? num.derivate().times(denom).minus(num.times(denom.derivate())) : num.derivate()).roots()) != null) {
                for (int i = 0; i < roots.length; ++i) {
                    double x;
                    if (!(Math.abs(roots[i].getIm()) < 1.0E-7) || !((x = roots[i].getRe()) > -1.0) || !(x < 1.0) || Double.isNaN(y = this.evaluate(num, denom, x)) || !(y < this.m_min)) continue;
                    this.m_min = y;
                    this.m_x = Math.acos(x);
                }
            }
        }

        private double evaluate(Polynomial num, Polynomial denom, double x) {
            if (Math.abs(x) < 1.0E-9) {
                x = 0.0;
            }
            double n = num.evaluateAt(x);
            double d = denom.evaluateAt(x);
            if (Math.abs(d) > 1.0E-7) {
                return n / d;
            }
            if (Math.abs(n) > 1.0E-7) {
                return Double.NaN;
            }
            if (x == 0.0) {
                int rmax = Math.min(num.getDegree(), denom.getDegree());
                for (int i = 1; i <= rmax; ++i) {
                    boolean sd;
                    double cn = num.get(i);
                    double cd = denom.get(i);
                    boolean sn = Math.abs(cn) > 1.0E-7;
                    boolean bl = sd = Math.abs(cd) > 1.0E-7;
                    if (sn && sd) {
                        return cn / cd;
                    }
                    if (sn) {
                        return Double.NaN;
                    }
                    if (!sd) continue;
                    return 0.0;
                }
                return Double.NaN;
            }
            double[] r = new double[]{1.0, -x};
            Polynomial R = Polynomial.of(r);
            return this.evaluate(num.divide(R), denom.divide(R), x);
        }

        private static class SpectrumFunction
        implements IFunction {
            private final Spectrum spec;
            private final double a;
            private final double b;

            SpectrumFunction(Spectrum spec) {
                this.spec = spec;
                this.a = 0.0;
                this.b = Math.PI;
            }

            SpectrumFunction(Spectrum spec, double a, double b) {
                this.spec = spec;
                this.a = a;
                this.b = b;
            }

            @Override
            public IFunctionInstance evaluate(IReadDataBlock parameters) {
                return new SpectrumFunctionInstance(this.spec, parameters.get(0));
            }

            @Override
            public IFunctionDerivatives getDerivatives(IFunctionInstance point) {
                return new NumericalDerivatives(this, point, true);
            }

            @Override
            public IParametersDomain getDomain() {
                return new ParametersRange(this.a, this.b, true);
            }
        }

        private static class SpectrumFunctionInstance
        implements IFunctionInstance {
            private final Spectrum spec;
            private final double pt;

            SpectrumFunctionInstance(Spectrum spec, double pt) {
                this.spec = spec;
                this.pt = pt;
            }

            @Override
            public IReadDataBlock getParameters() {
                return new SingleParameter(this.pt);
            }

            @Override
            public double getValue() {
                return Spectrum.value(this.spec, this.pt);
            }
        }
    }
}

