/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima;

import ec.tstoolkit.arima.AbstractArimaModel;
import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.AutoCovarianceFunction;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.Spectrum;
import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFrequencyResponseDecomposer;
import ec.tstoolkit.maths.linearfilters.SymmetricFrequencyResponseDecomposer3;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRootsSolver;

public class ArimaModel
extends AbstractArimaModel
implements IArimaModel {
    private static final double EPS = 1.0E-4;
    private BackFilter bar_;
    private BackFilter bma_;
    private BackFilter delta_;
    private double var_;
    private SymmetricFilter sar_;
    private SymmetricFilter sma_;
    private boolean st_;
    private boolean inv_;
    private boolean initprop_;

    public static ArimaModel add(double var, ArimaModel arima) {
        return arima.plus(var);
    }

    public static ArimaModel add(IArimaModel l, ArimaModel r) {
        ArimaModel m = ArimaModel.create(l);
        if (m == null) {
            throw new ArimaException("+ operation failed");
        }
        return m.plus(r);
    }

    public static ArimaModel subtract(IArimaModel l, ArimaModel r) {
        ArimaModel m = ArimaModel.create(l);
        if (m == null) {
            throw new ArimaException("+ operation failed");
        }
        return m.minus(r);
    }

    private static BackFilter check(BackFilter bf) {
        int n;
        if (bf == null) {
            return null;
        }
        Polynomial c = bf.getPolynomial();
        for (n = 0; n <= c.getDegree() && c.get(n) == 0.0; ++n) {
        }
        if (n == c.getDegree() + 1) {
            return BackFilter.ZERO;
        }
        if (n > 0) {
            double[] nc = new double[c.getDegree() + 1 - n];
            for (int i = 0; i < nc.length; ++i) {
                nc[i] = c.get(i + n);
            }
            return BackFilter.of(nc);
        }
        return null;
    }

    public static boolean same(IArimaModel lm, IArimaModel rm, double eps) {
        if (Math.abs(lm.getInnovationVariance() - rm.getInnovationVariance()) > eps) {
            return false;
        }
        if (!ArimaModel.same(lm.getNonStationaryAR().getCoefficients(), rm.getNonStationaryAR().getCoefficients(), eps)) {
            return false;
        }
        if (!ArimaModel.same(lm.getStationaryAR().getCoefficients(), rm.getStationaryAR().getCoefficients(), eps)) {
            return false;
        }
        return ArimaModel.same(lm.getMA().getCoefficients(), rm.getMA().getCoefficients(), eps);
    }

    private static boolean same(double[] l, double[] r, double eps) {
        int ll;
        if (l == null && r == null) {
            return true;
        }
        if (l == null || r == null) {
            return false;
        }
        int lr = r.length - 1;
        for (ll = l.length - 1; ll >= 0 && Math.abs(l[ll]) < eps; --ll) {
        }
        while (lr >= 0 && Math.abs(r[lr]) < eps) {
            --lr;
        }
        if (ll != lr) {
            return false;
        }
        for (int i = 0; i <= lr; ++i) {
            if (!(Math.abs(l[i] - r[i]) > eps)) continue;
            return false;
        }
        return true;
    }

    public ArimaModel scaleVariance(double factor) {
        ArimaModel m = new ArimaModel();
        double var = this.getInnovationVariance();
        if (var == 0.0) {
            return this;
        }
        m.delta_ = this.delta_;
        m.bar_ = this.bar_;
        m.bma_ = this.bma_;
        m.var_ = var * factor;
        m.sar_ = this.sar_;
        if (this.sma_ != null) {
            m.sma_ = this.sma_.times(factor);
        }
        return m;
    }

    @Override
    protected AutoCovarianceFunction initAcgf() throws ArimaException {
        if (this.sma_ != null) {
            return new AutoCovarianceFunction(this.sma_, this.getAR());
        }
        return super.initAcgf();
    }

    public ArimaModel normalize() {
        return this.scaleVariance(1.0 / this.getInnovationVariance());
    }

    public static ArimaModel create(IArimaModel arima) {
        try {
            ArimaModel m = new ArimaModel();
            m.delta_ = arima.getNonStationaryAR();
            m.bar_ = arima.getStationaryAR();
            m.bma_ = arima.getMA();
            m.var_ = arima.getInnovationVariance();
            return m;
        }
        catch (ArimaException ex) {
            return null;
        }
    }

    private static ArimaModel pm(ArimaModel l, ArimaModel r, boolean plus, boolean simplify) {
        BackFilter ur;
        BackFilter ar;
        if (r.isWhiteNoise()) {
            if (plus) {
                return l.plus(r.var_);
            }
            return l.minus(r.var_);
        }
        if (l.isWhiteNoise() && plus) {
            return ArimaModel.add(l.var_, r);
        }
        BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool(false);
        BackFilter lar = l.bar_;
        BackFilter rar = r.bar_;
        if (smp.simplify(lar, rar)) {
            ar = lar.times((BackFilter)smp.getRight());
            lar = (BackFilter)smp.getLeft();
            rar = (BackFilter)smp.getRight();
        } else {
            ar = lar.times(rar);
        }
        BackFilter lur = l.delta_;
        BackFilter rur = r.delta_;
        BackFilter.SimplifyingTool smpur = new BackFilter.SimplifyingTool(true);
        if (smpur.simplify(lur, rur)) {
            ur = lur.times((BackFilter)smpur.getRight());
            lar = lar.times((BackFilter)smpur.getLeft());
            rar = rar.times((BackFilter)smpur.getRight());
        } else {
            ur = lur.times(rur);
            lar = lar.times(lur);
            rar = rar.times(rur);
        }
        SymmetricFilter sl = SymmetricFilter.createFromFilter(lar);
        SymmetricFilter sr = SymmetricFilter.createFromFilter(rar);
        SymmetricFilter lma = l.sma();
        SymmetricFilter rma = r.sma();
        SymmetricFilter snum = plus ? lma.times(sr).plus(rma.times(sl)) : lma.times(sr).minus(rma.times(sl));
        if (snum.isNull()) {
            return new ArimaModel(null, null, null, 0.0);
        }
        ArimaModel rslt = new ArimaModel(ar, ur, null, null, 0.0, snum);
        if (simplify) {
            rslt.simplify();
        } else {
            rslt.simplifyAr();
        }
        return rslt;
    }

    public ArimaModel() {
        this.bar_ = BackFilter.ONE;
        this.bma_ = BackFilter.ONE;
        this.delta_ = BackFilter.ONE;
        this.var_ = 1.0;
    }

    public ArimaModel(double var) {
        this.bar_ = BackFilter.ONE;
        this.bma_ = BackFilter.ONE;
        this.delta_ = BackFilter.ONE;
        this.var_ = var;
    }

    public ArimaModel(BackFilter ar, BackFilter delta, BackFilter ma, double var) {
        this.var_ = var;
        this.bar_ = ar == null ? BackFilter.ONE : ar;
        this.bma_ = ma == null ? BackFilter.ONE : ma;
        this.delta_ = delta == null ? BackFilter.ONE : delta;
        this.check();
    }

    public ArimaModel(BackFilter ar, BackFilter delta, SymmetricFilter sma) {
        this.bar_ = ar == null ? BackFilter.ONE : ar;
        if (sma == null) {
            this.bma_ = BackFilter.ONE;
        } else {
            this.sma_ = sma;
        }
        this.delta_ = delta == null ? BackFilter.ONE : delta;
        this.check();
    }

    public ArimaModel(BackFilter bar, BackFilter ur, SymmetricFilter sar, BackFilter bma, double var, SymmetricFilter sma) {
        this.bar_ = bar;
        this.delta_ = ur;
        this.sar_ = sar;
        this.bma_ = bma;
        this.sma_ = sma;
        this.var_ = var;
        this.check();
    }

    public ArimaModel(IArimaModel starima, BackFilter ur) {
        if (!starima.isStationary()) {
            throw new ArimaException("acgf_err_st");
        }
        this.bar_ = starima.getAR();
        this.bma_ = starima.getMA();
        this.delta_ = ur == null ? BackFilter.ONE : ur;
        this.var_ = starima.getInnovationVariance();
    }

    private void ar_btos() {
        this.sar_ = SymmetricFilter.createFromFilter(this.bar_.times(this.delta_));
    }

    private BackFilter bma() throws ArimaException {
        if (this.bma_ == null) {
            this.ma_stob();
        }
        return this.bma_;
    }

    private void check() {
        if (this.delta_ == null) {
            this.delta_ = BackFilter.ONE;
        }
        if (this.bar_ == null) {
            this.bar_ = BackFilter.ONE;
        } else {
            BackFilter ar = ArimaModel.check(this.bar_);
            if (ar != null) {
                this.bar_ = ar;
                this.sar_ = null;
            }
        }
        BackFilter ma = ArimaModel.check(this.bma_);
        if (ma != null) {
            this.bma_ = ma;
            this.sma_ = null;
        }
    }

    @Override
    public BackFilter getAR() {
        return this.bar_.times(this.delta_);
    }

    @Override
    public int getARCount() {
        return this.getStationaryARCount() + this.getNonStationaryARCount();
    }

    @Override
    public double getInnovationVariance() throws ArimaException {
        return this.var();
    }

    @Override
    public BackFilter getMA() {
        return this.bma();
    }

    @Override
    public int getMACount() {
        if (this.bma_ != null) {
            return this.bma_.getDegree();
        }
        return this.sma_.getDegree();
    }

    @Override
    public BackFilter getNonStationaryAR() {
        return this.delta_;
    }

    @Override
    public int getNonStationaryARCount() {
        return this.delta_.getDegree();
    }

    @Override
    public BackFilter getStationaryAR() {
        return this.bar_;
    }

    @Override
    public int getStationaryARCount() {
        return this.bar_.getDegree();
    }

    private void initproperties() {
        block4: {
            this.st_ = true;
            if (this.delta_.getLength() > 1) {
                this.st_ = false;
            }
            try {
                Complex[] rma = this.bma().roots();
                this.inv_ = true;
                if (rma == null) break block4;
                for (int i = 0; i < rma.length; ++i) {
                    double nrm = rma[i].absSquare();
                    if (!(nrm <= 1.0001)) continue;
                    this.inv_ = false;
                    break;
                }
            }
            catch (ArimaException ex) {
                this.inv_ = false;
            }
        }
        this.initprop_ = true;
    }

    @Override
    protected Spectrum initSpectrum() {
        return new Spectrum(this.sma(), this.sar());
    }

    @Override
    public boolean isInvertible() {
        if (!this.initprop_) {
            this.initproperties();
        }
        return this.inv_;
    }

    @Override
    public boolean isNull() {
        return this.delta_.getDegree() == 0 && (this.sma_ != null ? this.sma_.isNull() : this.var_ == 0.0);
    }

    @Override
    public boolean isStationary() {
        if (!this.initprop_) {
            this.initproperties();
        }
        return this.st_;
    }

    public boolean isWhiteNoise() {
        if (this.bar_.getDegree() != 0) {
            return false;
        }
        if (this.delta_.getDegree() != 0) {
            return false;
        }
        if (this.bma_ != null && this.bma_.getDegree() != 0) {
            return false;
        }
        if (this.sma_ != null && this.sma_.getDegree() != 0) {
            return false;
        }
        if (this.bma_ == null) {
            if (this.sma_ == null) {
                this.var_ = 0.0;
            } else {
                this.var_ = this.sma_.getWeight(0);
                this.bma_ = BackFilter.ONE;
            }
        }
        return true;
    }

    private void ma_btos() {
        this.sma_ = SymmetricFilter.createFromFilter(this.bma_);
        this.sma_ = this.sma_.times(this.var_);
    }

    private void ma_stob() {
        if (this.sma_.getLength() == 1) {
            this.bma_ = BackFilter.ONE;
            this.var_ = this.sma_.getWeight(0);
        } else {
            this.ma_stob2();
        }
    }

    private void ma_stob2() {
        SymmetricFrequencyResponseDecomposer sfr = new SymmetricFrequencyResponseDecomposer();
        if (sfr.decompose(this.sma_)) {
            this.bma_ = sfr.getBFilter();
            this.var_ = sfr.getFactor();
        } else {
            SymmetricFrequencyResponseDecomposer3 sfr3 = new SymmetricFrequencyResponseDecomposer3();
            if (sfr3.decompose(this.sma_)) {
                this.bma_ = sfr3.getBFilter();
                this.var_ = sfr3.getFactor();
            } else {
                throw new ArimaException("dcmp_err_invalid");
            }
        }
    }

    public ArimaModel minus(ArimaModel r) {
        return ArimaModel.pm(this, r, false, false);
    }

    public ArimaModel minus(ArimaModel r, boolean simplify) {
        return ArimaModel.pm(this, r, false, simplify);
    }

    public ArimaModel minus(double v) {
        if (this.isWhiteNoise()) {
            return new ArimaModel(null, null, null, this.var_ - v);
        }
        SymmetricFilter sma = this.sma();
        SymmetricFilter sar = this.sar();
        SymmetricFilter snum = sma.minus(SymmetricFilter.multiply(v, sar));
        ArimaModel rslt = new ArimaModel(this.bar_, this.delta_, this.sar_, null, 0.0, snum);
        return rslt;
    }

    public ArimaModel plus(ArimaModel r) {
        return ArimaModel.pm(this, r, true, true);
    }

    public ArimaModel plus(ArimaModel r, boolean simplify) {
        return ArimaModel.pm(this, r, true, simplify);
    }

    public ArimaModel plus(double v) {
        if (this.isWhiteNoise()) {
            return new ArimaModel(null, null, null, v + this.var_);
        }
        SymmetricFilter sma = this.sma();
        SymmetricFilter sar = this.sar();
        SymmetricFilter snum = sma.plus(SymmetricFilter.multiply(v, sar));
        ArimaModel rslt = new ArimaModel(this.bar_, this.delta_, this.sar_, null, 0.0, snum);
        return rslt;
    }

    public ArimaModel plus(IArimaModel r) throws ArimaException {
        ArimaModel m = ArimaModel.create(r);
        if (m == null) {
            throw new ArimaException("+ operation failed");
        }
        return this.plus(m);
    }

    SymmetricFilter sar() {
        if (this.sar_ == null) {
            this.ar_btos();
        }
        return this.sar_;
    }

    public boolean simplify() {
        boolean sar = this.simplifyAr();
        boolean sur = this.simplifyUr();
        if (sar || sur) {
            this.clearCachedObjects();
            return true;
        }
        return false;
    }

    public boolean simplifyAr() {
        try {
            BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool(false);
            if (smp.simplify(this.bar_, this.bma())) {
                this.bar_ = (BackFilter)smp.getLeft();
                this.bma_ = (BackFilter)smp.getRight();
                this.sar_ = null;
                this.sma_ = null;
                return true;
            }
            return false;
        }
        catch (ArimaException e) {
            return false;
        }
    }

    public boolean simplifyUr() {
        try {
            UnitRootsSolver urs = new UnitRootsSolver();
            if (!urs.factorize(this.bma().getPolynomial())) {
                return false;
            }
            Polynomial.SimplifyingTool smp = new Polynomial.SimplifyingTool();
            if (smp.simplify(urs.getUnitRoots().toPolynomial(), this.delta_.getPolynomial())) {
                this.delta_ = new BackFilter((Polynomial)smp.getRight());
                this.bma_ = new BackFilter(((Polynomial)smp.getLeft()).times(urs.remainder()));
                this.sma_ = null;
                return true;
            }
            return false;
        }
        catch (ArimaException e) {
            return false;
        }
    }

    public SymmetricFilter sma() {
        if (this.sma_ == null) {
            this.ma_btos();
        }
        return this.sma_;
    }

    @Override
    public StationaryTransformation stationaryTransformation() {
        return new StationaryTransformation(new ArimaModel(this.bar_, BackFilter.ONE, null, this.bma_, this.var_, this.sma_), this.delta_);
    }

    double var() throws ArimaException {
        if (this.bma_ == null) {
            this.ma_stob();
        }
        return this.var_;
    }
}

