/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.SeasonalFilterFactory;
import ec.satoolkit.x11.TrendCycleFilterFactory;
import ec.satoolkit.x11.X11Exception;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;

public class DefaultSpecification {
    private boolean mul = true;
    private double lsigma = 1.5;
    private double usigma = 2.5;
    private int henderson = -1;

    public int getHendersonFilterLength() {
        return this.henderson;
    }

    public double getLowerSigma() {
        return this.lsigma;
    }

    public SymmetricFilter getSeasonalFilter() {
        return SeasonalFilterFactory.S3X5;
    }

    public int getSeasonalFilterLength() {
        return 7;
    }

    public SymmetricFilter getTrendFilter() {
        return TrendCycleFilterFactory.makeHendersonFilter(13);
    }

    public double getUpperSigma() {
        return this.usigma;
    }

    public boolean isAutoHenderson() {
        return this.henderson < 0;
    }

    public boolean isMultiplicative() {
        return this.mul;
    }

    public void setMultiplicative(boolean mul) {
        this.mul = mul;
    }

    public void setSigma(double lsig, double usig) {
        if (usig <= lsig || lsig <= 0.5) {
            throw new X11Exception("Invalid sigma options");
        }
        this.lsigma = lsig;
        this.usigma = usig;
    }
}

