/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;

public class SubMatrix
implements Cloneable {
    final double[] m_data;
    final int m_row_inc;
    final int m_col_inc;
    int m_start;
    int m_nrows;
    int m_ncols;
    private static final int PROD_THRESHOLD = 6;

    public SubMatrix(double[] data, int nrows, int ncols) {
        this.m_data = data;
        this.m_nrows = nrows;
        this.m_ncols = ncols;
        this.m_row_inc = 1;
        this.m_col_inc = nrows;
    }

    public SubMatrix(double[] data, int start, int nrows, int ncols, int rowinc, int colinc) {
        this.m_data = data;
        this.m_start = start;
        this.m_nrows = nrows;
        this.m_ncols = ncols;
        this.m_row_inc = rowinc;
        this.m_col_inc = colinc;
    }

    public SubMatrix(SubMatrix m) {
        this.m_data = m.m_data;
        this.m_start = m.m_start;
        this.m_nrows = m.m_nrows;
        this.m_ncols = m.m_ncols;
        this.m_row_inc = m.m_row_inc;
        this.m_col_inc = m.m_col_inc;
    }

    public void add(double val) {
        if (val == 0.0) {
            return;
        }
        if (this.m_row_inc == 1) {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int ir = ic;
                for (int r = 0; r < this.m_nrows; ++r) {
                    int n = ir++;
                    this.m_data[n] = this.m_data[n] + val;
                }
                ++c;
                ic += this.m_col_inc;
            }
        } else if (this.m_col_inc == 1) {
            int r = 0;
            int ir = this.m_start;
            while (r < this.m_nrows) {
                int ic = ir;
                for (int c = 0; c < this.m_ncols; ++c) {
                    int n = ic++;
                    this.m_data[n] = this.m_data[n] + val;
                }
                ++r;
                ir += this.m_row_inc;
            }
        } else {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    int n = ir;
                    this.m_data[n] = this.m_data[n] + val;
                    ++r;
                    ir += this.m_row_inc;
                }
                ++c;
                ic += this.m_col_inc;
            }
        }
    }

    public void add(int row, int col, double val) {
        int n = this.m_start + row * this.m_row_inc + col * this.m_col_inc;
        this.m_data[n] = this.m_data[n] + val;
    }

    public void add(SubMatrix m) {
        DataBlockIterator siter;
        DataBlockIterator iter;
        if (this.isFull() && m.isFull()) {
            for (int i = 0; i < this.m_data.length; ++i) {
                int n = i;
                this.m_data[n] = this.m_data[n] + m.m_data[i];
            }
            return;
        }
        if (m.m_row_inc == 1 && this.m_row_inc == 1) {
            iter = this.columns();
            siter = m.columns();
        } else {
            iter = this.rows();
            siter = m.rows();
        }
        DataBlock icur = iter.getData();
        DataBlock sicur = siter.getData();
        do {
            icur.add(sicur);
        } while (iter.next() && siter.next());
    }

    public void addTo(SubMatrix m, int i, int j) {
        int scur = this.m_start;
        int tcur = m.m_start + i * m.m_row_inc + j * m.m_col_inc;
        int c = 0;
        while (c < this.m_ncols) {
            int r = 0;
            int sidx = scur;
            int tidx = tcur;
            while (r < this.m_nrows) {
                int n = tidx;
                m.m_data[n] = m.m_data[n] + this.m_data[sidx];
                ++r;
                sidx += this.m_row_inc;
                tidx += m.m_row_inc;
            }
            ++c;
            scur += this.m_col_inc;
            tcur += m.m_col_inc;
        }
    }

    public void subTo(SubMatrix m, int i, int j) {
        int scur = this.m_start;
        int tcur = m.m_start + i * m.m_row_inc + j * m.m_col_inc;
        int c = 0;
        while (c < this.m_ncols) {
            int r = 0;
            int sidx = scur;
            int tidx = tcur;
            while (r < this.m_nrows) {
                int n = tidx;
                m.m_data[n] = m.m_data[n] - this.m_data[sidx];
                ++r;
                sidx += this.m_row_inc;
                tidx += m.m_row_inc;
            }
            ++c;
            scur += this.m_col_inc;
            tcur += m.m_col_inc;
        }
    }

    public void chs() {
        if (this.m_row_inc == 1) {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    this.m_data[ir] = -this.m_data[ir];
                    ++r;
                    ++ir;
                }
                ++c;
                ic += this.m_col_inc;
            }
        } else if (this.m_col_inc == 1) {
            int r = 0;
            int ir = this.m_start;
            while (r < this.m_nrows) {
                int c = 0;
                int ic = ir;
                while (c < this.m_ncols) {
                    this.m_data[ic] = -this.m_data[ic];
                    ++c;
                    ++ic;
                }
                ++r;
                ir += this.m_row_inc;
            }
        } else {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    this.m_data[ir] = -this.m_data[ir];
                    ++r;
                    ir += this.m_row_inc;
                }
                ++c;
                ic += this.m_col_inc;
            }
        }
    }

    public void set(Matrix.MatrixFunction fn) {
        if (this.m_row_inc == 1) {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    this.m_data[ir] = fn.apply(r, c);
                    ++r;
                    ++ir;
                }
                ++c;
                ic += this.m_col_inc;
            }
        } else if (this.m_col_inc == 1) {
            int r = 0;
            int ir = this.m_start;
            while (r < this.m_nrows) {
                int c = 0;
                int ic = ir;
                while (c < this.m_ncols) {
                    this.m_data[ic] = fn.apply(r, c);
                    ++c;
                    ++ic;
                }
                ++r;
                ir += this.m_row_inc;
            }
        } else {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    this.m_data[ir] = fn.apply(r, c);
                    ++r;
                    ir += this.m_row_inc;
                }
                ++c;
                ic += this.m_col_inc;
            }
        }
    }

    public void add(Matrix.MatrixFunction fn) {
        if (this.m_row_inc == 1) {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int ir = ic;
                for (int r = 0; r < this.m_nrows; ++r) {
                    int n = ir++;
                    this.m_data[n] = this.m_data[n] + fn.apply(r, c);
                }
                ++c;
                ic += this.m_col_inc;
            }
        } else if (this.m_col_inc == 1) {
            int r = 0;
            int ir = this.m_start;
            while (r < this.m_nrows) {
                int ic = ir;
                for (int c = 0; c < this.m_ncols; ++c) {
                    int n = ic++;
                    this.m_data[n] = this.m_data[n] + fn.apply(r, c);
                }
                ++r;
                ir += this.m_row_inc;
            }
        } else {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    int n = ir;
                    this.m_data[n] = this.m_data[n] + fn.apply(r, c);
                    ++r;
                    ir += this.m_row_inc;
                }
                ++c;
                ic += this.m_col_inc;
            }
        }
    }

    public void set(Matrix.MatrixRelativeFunction fn) {
        if (this.m_row_inc == 1) {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    this.m_data[ir] = fn.apply(r, c, this.m_data[ir]);
                    ++r;
                    ++ir;
                }
                ++c;
                ic += this.m_col_inc;
            }
        } else if (this.m_col_inc == 1) {
            int r = 0;
            int ir = this.m_start;
            while (r < this.m_nrows) {
                int c = 0;
                int ic = ir;
                while (c < this.m_ncols) {
                    this.m_data[ic] = fn.apply(r, c, this.m_data[ic]);
                    ++c;
                    ++ic;
                }
                ++r;
                ir += this.m_row_inc;
            }
        } else {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    this.m_data[ir] = fn.apply(r, c, this.m_data[ir]);
                    ++r;
                    ir += this.m_row_inc;
                }
                ++c;
                ic += this.m_col_inc;
            }
        }
    }

    public void add(Matrix.MatrixRelativeFunction fn) {
        if (this.m_row_inc == 1) {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    int n = ir;
                    this.m_data[n] = this.m_data[n] + fn.apply(r, c, this.m_data[ir]);
                    ++r;
                    ++ir;
                }
                ++c;
                ic += this.m_col_inc;
            }
        } else if (this.m_col_inc == 1) {
            int r = 0;
            int ir = this.m_start;
            while (r < this.m_nrows) {
                int c = 0;
                int ic = ir;
                while (c < this.m_ncols) {
                    int n = ic;
                    this.m_data[n] = this.m_data[n] + fn.apply(r, c, this.m_data[ic]);
                    ++c;
                    ++ic;
                }
                ++r;
                ir += this.m_row_inc;
            }
        } else {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    int n = ir;
                    this.m_data[n] = this.m_data[n] + fn.apply(r, c, this.m_data[ir]);
                    ++r;
                    ir += this.m_row_inc;
                }
                ++c;
                ic += this.m_col_inc;
            }
        }
    }

    public SubMatrix clone() {
        try {
            return (SubMatrix)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public DataBlock column(int c) {
        int beg = this.m_start + c * this.m_col_inc;
        int end = beg + this.m_row_inc * this.m_nrows;
        return new DataBlock(this.m_data, beg, end, this.m_row_inc);
    }

    public DataBlockIterator columns() {
        return new DataBlockIterator(this.m_data, this.m_start, this.m_ncols, this.m_nrows, this.m_col_inc, this.m_row_inc);
    }

    public void copy(SubMatrix m) {
        if (this.isFull() && m.isFull()) {
            System.arraycopy(m.m_data, 0, this.m_data, 0, this.m_data.length);
            return;
        }
        int scur = m.m_start;
        int tcur = this.m_start;
        int c = 0;
        while (c < this.m_ncols) {
            int r = 0;
            int sidx = scur;
            int tidx = tcur;
            while (r < this.m_nrows) {
                this.m_data[tidx] = m.m_data[sidx];
                ++r;
                sidx += m.m_row_inc;
                tidx += this.m_row_inc;
            }
            ++c;
            scur += m.m_col_inc;
            tcur += this.m_col_inc;
        }
    }

    public void copyRows(SubMatrix src, boolean[] brows) {
        DataBlockIterator iter = this.rows();
        DataBlockIterator siter = src.rows();
        DataBlock icur = iter.getData();
        DataBlock sicur = siter.getData();
        int i = 0;
        do {
            if (!brows[i]) continue;
            icur.copy(sicur);
            if (siter.next()) continue;
            return;
        } while (++i < brows.length && iter.next());
    }

    public void copyRows(SubMatrix src, int[] irows) {
        for (int i = 0; i < irows.length && i < src.getRowsCount(); ++i) {
            this.row(irows[i]).copy(src.row(i));
        }
    }

    public void copyColumns(SubMatrix src, boolean[] bcols) {
        DataBlockIterator iter = this.columns();
        DataBlockIterator siter = src.columns();
        DataBlock icur = iter.getData();
        DataBlock sicur = siter.getData();
        int i = 0;
        do {
            if (!bcols[i]) continue;
            icur.copy(sicur);
            if (siter.next()) continue;
            return;
        } while (++i < bcols.length && iter.next());
    }

    public void copyColumns(SubMatrix src, int[] icols) {
        for (int i = 0; i < icols.length && i < src.getColumnsCount(); ++i) {
            this.column(icols[i]).copy(src.column(i));
        }
    }

    public void copy(SubMatrix src, boolean[] brows, boolean[] bcols) {
        int rmax = Math.max(brows.length, this.m_nrows);
        int cmax = Math.max(bcols.length, this.m_ncols);
        int sc = 0;
        for (int c = 0; c < cmax; ++c) {
            if (!bcols[c]) continue;
            int sr = 0;
            for (int r = 0; r < rmax; ++r) {
                if (!brows[r]) continue;
                this.set(r, c, src.get(sr, sc));
                ++sr;
            }
            ++sc;
        }
    }

    public void copy(SubMatrix src, int[] irows, int[] icols) {
        int rmax = Math.max(irows.length, src.m_nrows);
        int cmax = Math.max(icols.length, src.m_ncols);
        for (int c = 0; c < cmax; ++c) {
            for (int r = 0; r < rmax; ++r) {
                this.set(irows[r], icols[c], src.get(r, c));
            }
        }
    }

    public void copyTo(SubMatrix m, int i, int j) {
        int scur = this.m_start;
        int tcur = m.m_start + i * m.m_row_inc + j * m.m_col_inc;
        int c = 0;
        while (c < this.m_ncols) {
            int r = 0;
            int sidx = scur;
            int tidx = tcur;
            while (r < this.m_nrows) {
                m.m_data[tidx] = this.m_data[sidx];
                ++r;
                sidx += this.m_row_inc;
                tidx += m.m_row_inc;
            }
            ++c;
            scur += this.m_col_inc;
            tcur += m.m_col_inc;
        }
    }

    public void setAY(double a, SubMatrix Y) {
        DataBlockIterator siter;
        DataBlockIterator iter;
        if (this.m_row_inc == 1) {
            iter = this.columns();
            siter = Y.columns();
        } else {
            iter = this.rows();
            siter = Y.rows();
        }
        DataBlock icur = iter.getData();
        DataBlock sicur = siter.getData();
        do {
            icur.setAY(a, sicur);
        } while (iter.next() && siter.next());
    }

    public void addAY(double a, SubMatrix Y) {
        DataBlockIterator siter;
        DataBlockIterator iter;
        if (a == 0.0) {
            return;
        }
        if (this.m_row_inc == 1) {
            iter = this.columns();
            siter = Y.columns();
        } else {
            iter = this.rows();
            siter = Y.rows();
        }
        DataBlock icur = iter.getData();
        DataBlock sicur = siter.getData();
        do {
            icur.addAY(a, sicur);
        } while (iter.next() && siter.next());
    }

    public void addXaXt(double a, DataBlock x) {
        DataBlockIterator cols = this.columns();
        DataBlock col = cols.getData();
        do {
            double z = a * x.get(cols.getPosition());
            col.addAY(z, x);
        } while (cols.next());
    }

    public void addXaYt(double a, DataBlock x, DataBlock y) {
        DataBlockIterator cols = this.columns();
        DataBlock col = cols.getData();
        do {
            double z = a * y.get(cols.getPosition());
            col.addAY(z, x);
        } while (cols.next());
    }

    public DataBlock diagonal() {
        int n = Math.min(this.m_nrows, this.m_ncols);
        int inc = this.m_row_inc + this.m_col_inc;
        return new DataBlock(this.m_data, this.m_start, this.m_start + inc * n, inc);
    }

    public void difference(SubMatrix ls, SubMatrix rs) {
        DataBlockIterator riter;
        DataBlockIterator liter;
        DataBlockIterator iter;
        if (ls.m_row_inc == 1 && rs.m_row_inc == 1 && this.m_row_inc == 1) {
            iter = this.columns();
            liter = ls.columns();
            riter = rs.columns();
        } else {
            iter = this.rows();
            liter = ls.rows();
            riter = rs.rows();
        }
        DataBlock icur = iter.getData();
        DataBlock lcur = liter.getData();
        DataBlock rcur = riter.getData();
        do {
            icur.difference(lcur, rcur);
        } while (iter.next() && liter.next() && riter.next());
    }

    public SubMatrix extract(int r0, int r1, int c0, int c1) {
        return new SubMatrix(this.m_data, this.m_start + r0 * this.m_row_inc + c0 * this.m_col_inc, r1 - r0, c1 - c0, this.m_row_inc, this.m_col_inc);
    }

    public SubMatrix extract(int r0, int c0, int nrows, int ncols, int rowinc, int colinc) {
        return new SubMatrix(this.m_data, this.m_start + r0 * this.m_row_inc + c0 * this.m_col_inc, nrows, ncols, this.m_row_inc * rowinc, this.m_col_inc * colinc);
    }

    public double get(int row, int col) {
        return this.m_data[this.m_start + row * this.m_row_inc + col * this.m_col_inc];
    }

    public int getColumnsCount() {
        return this.m_ncols;
    }

    public int getRowsCount() {
        return this.m_nrows;
    }

    public void move(int dr, int dc) {
        this.m_start += dr * this.m_row_inc + dc * this.m_col_inc;
    }

    public void mul(double val) {
        if (val == 0.0) {
            this.set(0.0);
        }
        if (val == 1.0) {
            return;
        }
        if (this.m_row_inc == 1) {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int ir = ic;
                for (int r = 0; r < this.m_nrows; ++r) {
                    int n = ir++;
                    this.m_data[n] = this.m_data[n] * val;
                }
                ++c;
                ic += this.m_col_inc;
            }
        } else if (this.m_col_inc == 1) {
            int r = 0;
            int ir = this.m_start;
            while (r < this.m_nrows) {
                int ic = ir;
                for (int c = 0; c < this.m_ncols; ++c) {
                    int n = ic++;
                    this.m_data[n] = this.m_data[n] * val;
                }
                ++r;
                ir += this.m_row_inc;
            }
        } else {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    int n = ir;
                    this.m_data[n] = this.m_data[n] * val;
                    ++r;
                    ir += this.m_row_inc;
                }
                ++c;
                ic += this.m_col_inc;
            }
        }
    }

    public void mul(int row, int col, double val) {
        int n = this.m_start + row * this.m_row_inc + col * this.m_col_inc;
        this.m_data[n] = this.m_data[n] * val;
    }

    public double dot(SubMatrix m) {
        double p = 0.0;
        DataBlockIterator cols = this.columns();
        DataBlockIterator mcols = m.columns();
        DataBlock col = cols.getData();
        DataBlock mcol = mcols.getData();
        do {
            p += col.dot(mcol);
        } while (cols.next() && mcols.next());
        return p;
    }

    public void product(SubMatrix m, SubMatrix n) {
        if (m.getColumnsCount() < 6 * m.getRowsCount()) {
            DataBlockIterator cols = this.columns();
            DataBlockIterator rcols = n.columns();
            DataBlockIterator lcols = m.columns();
            DataBlock col = cols.getData();
            DataBlock rcol = rcols.getData();
            DataBlock lcol = lcols.getData();
            do {
                lcols.begin();
                int k = 0;
                col.setAY(rcol.get(k++), lcol);
                while (lcols.next()) {
                    col.addAY(rcol.get(k++), lcol);
                }
            } while (cols.next() && rcols.next());
        } else {
            DataBlockIterator iter = this.columns();
            DataBlockIterator riter = m.rows();
            DataBlockIterator citer = n.columns();
            DataBlock cur = iter.getData();
            DataBlock col = citer.getData();
            DataBlock row = riter.getData();
            do {
                int pos = 0;
                riter.begin();
                do {
                    cur.set(pos++, row.dot(col));
                } while (riter.next());
            } while (iter.next() && citer.next());
        }
    }

    public void kronecker(SubMatrix m, SubMatrix n) {
        int rm = m.getRowsCount();
        int cm = m.getColumnsCount();
        int rn = n.getRowsCount();
        int cn = n.getColumnsCount();
        int r = 0;
        int i = 0;
        while (r < rm) {
            int c = 0;
            int j = 0;
            while (c < cm) {
                SubMatrix cur = this.extract(i, i + rn, j, j + cn);
                double e = m.get(r, c);
                if (e != 0.0) {
                    cur.setAY(e, n);
                }
                ++c;
                j += cn;
            }
            ++r;
            i += rn;
        }
    }

    public DataBlock row(int r) {
        int beg = this.m_start + r * this.m_row_inc;
        int end = beg + this.m_col_inc * this.m_ncols;
        return new DataBlock(this.m_data, beg, end, this.m_col_inc);
    }

    public DataBlockIterator rows() {
        return new DataBlockIterator(this.m_data, this.m_start, this.m_nrows, this.m_ncols, this.m_row_inc, this.m_col_inc);
    }

    public void set(double val) {
        if (this.m_row_inc == 1) {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    this.m_data[ir] = val;
                    ++r;
                    ++ir;
                }
                ++c;
                ic += this.m_col_inc;
            }
        } else if (this.m_col_inc == 1) {
            int r = 0;
            int ir = this.m_start;
            while (r < this.m_nrows) {
                int c = 0;
                int ic = ir;
                while (c < this.m_ncols) {
                    this.m_data[ic] = val;
                    ++c;
                    ++ic;
                }
                ++r;
                ir += this.m_row_inc;
            }
        } else {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    this.m_data[ir] = val;
                    ++r;
                    ir += this.m_row_inc;
                }
                ++c;
                ic += this.m_col_inc;
            }
        }
    }

    public void set(int row, int col, double value) {
        this.m_data[this.m_start + row * this.m_row_inc + col * this.m_col_inc] = value;
    }

    public void shift(int n) {
        block5: {
            block4: {
                if (n >= 0) break block4;
                int del = (this.m_row_inc + this.m_col_inc) * n;
                int c = 0;
                int i = this.m_start;
                while (c < this.m_ncols + n) {
                    int r = 0;
                    int j = i;
                    while (r < this.m_nrows + n) {
                        this.m_data[j] = this.m_data[j - del];
                        ++r;
                        j += this.m_row_inc;
                    }
                    ++c;
                    i += this.m_col_inc;
                }
                break block5;
            }
            if (n <= 0) break block5;
            int del = (this.m_row_inc + this.m_col_inc) * n;
            int c = n;
            int i = this.m_start + (this.m_nrows - 1) * this.m_row_inc + (this.m_ncols - 1) * this.m_col_inc;
            while (c < this.m_ncols) {
                int r = n;
                int j = i;
                while (r < this.m_nrows) {
                    this.m_data[j] = this.m_data[j - del];
                    ++r;
                    j -= this.m_row_inc;
                }
                ++c;
                i -= this.m_col_inc;
            }
        }
    }

    public void sub(SubMatrix m) {
        DataBlockIterator siter;
        DataBlockIterator iter;
        if (this.isFull() && m.isFull()) {
            for (int i = 0; i < this.m_data.length; ++i) {
                int n = i;
                this.m_data[n] = this.m_data[n] - m.m_data[i];
            }
            return;
        }
        if (m.m_row_inc == 1 && this.m_row_inc == 1) {
            iter = this.columns();
            siter = m.columns();
        } else {
            iter = this.rows();
            siter = m.rows();
        }
        DataBlock icur = iter.getData();
        DataBlock sicur = siter.getData();
        do {
            icur.sub(sicur);
        } while (iter.next() && siter.next());
    }

    public DataBlock subDiagonal(int pos) {
        int n;
        if (pos >= this.m_ncols) {
            return DataBlock.EMPTY;
        }
        if (-pos >= this.m_nrows) {
            return DataBlock.EMPTY;
        }
        int beg = this.m_start;
        int inc = this.m_row_inc + this.m_col_inc;
        if (pos > 0) {
            beg += pos * this.m_col_inc;
            n = Math.min(this.m_nrows, this.m_ncols - pos);
        } else if (pos < 0) {
            beg -= pos * this.m_row_inc;
            n = Math.min(this.m_nrows + pos, this.m_ncols);
        } else {
            n = Math.min(this.m_nrows, this.m_ncols);
        }
        return new DataBlock(this.m_data, beg, beg + inc * n, inc);
    }

    public double sum() {
        double s = 0.0;
        if (this.m_row_inc == 1) {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    s += this.m_data[ir];
                    ++r;
                    ++ir;
                }
                ++c;
                ic += this.m_col_inc;
            }
        } else if (this.m_col_inc == 1) {
            int r = 0;
            int ir = this.m_start;
            while (r < this.m_nrows) {
                int c = 0;
                int ic = ir;
                while (c < this.m_ncols) {
                    s += this.m_data[ic];
                    ++c;
                    ++ic;
                }
                ++r;
                ir += this.m_row_inc;
            }
        } else {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    s += this.m_data[ir];
                    ++r;
                    ir += this.m_row_inc;
                }
                ++c;
                ic += this.m_col_inc;
            }
        }
        return s;
    }

    public void sum(SubMatrix ls, SubMatrix rs) {
        DataBlockIterator riter;
        DataBlockIterator liter;
        DataBlockIterator iter;
        if (ls.m_row_inc == 1 && rs.m_row_inc == 1 && this.m_row_inc == 1) {
            iter = this.columns();
            liter = ls.columns();
            riter = rs.columns();
        } else {
            iter = this.rows();
            liter = ls.rows();
            riter = rs.rows();
        }
        DataBlock icur = iter.getData();
        DataBlock lcur = liter.getData();
        DataBlock rcur = riter.getData();
        do {
            icur.sum(lcur, rcur);
        } while (iter.next() && liter.next() && riter.next());
    }

    public SubMatrix transpose() {
        return new SubMatrix(this.m_data, this.m_start, this.m_ncols, this.m_nrows, this.m_col_inc, this.m_row_inc);
    }

    public boolean isEmpty() {
        return this.getColumnsCount() <= 0 || this.getRowsCount() <= 0;
    }

    public boolean isZero(double zero) {
        if (this.isFull()) {
            return new DataBlock(this.m_data).isZero(zero);
        }
        DataBlockIterator cols = this.columns();
        DataBlock col = cols.getData();
        do {
            if (col.isZero(zero)) continue;
            return false;
        } while (cols.next());
        return true;
    }

    @Deprecated
    public boolean isNull(double zero) {
        return this.isZero(zero);
    }

    public boolean isDiagonal() {
        return this.isLower() && this.isUpper();
    }

    public boolean isIdentity() {
        return this.isDiagonal() && this.diagonal().isConstant(1.0);
    }

    public boolean isLower() {
        for (int i = 1; i < this.m_ncols; ++i) {
            if (this.subDiagonal(i).isZero()) continue;
            return false;
        }
        return true;
    }

    public boolean isUpper() {
        for (int i = 1; i < this.m_nrows; ++i) {
            if (this.subDiagonal(-i).isZero()) continue;
            return false;
        }
        return true;
    }

    private boolean isFull() {
        return this.m_nrows * this.m_ncols == this.m_data.length && this.m_row_inc == 1;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        DataBlockIterator rows = this.rows();
        do {
            builder.append(rows.getData()).append(System.lineSeparator());
        } while (rows.next());
        return builder.toString();
    }

    public String toString(String fmt) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        DataBlockIterator rows = this.rows();
        do {
            if (rows.getPosition() > 0) {
                builder.append(System.lineSeparator());
            }
            builder.append(rows.getData().toString(fmt));
        } while (rows.next());
        return builder.toString();
    }

    public DataBlock rowSum() {
        return this.rows().sum();
    }

    public DataBlock columnSum() {
        return this.columns().sum();
    }

    public void xmy(SubMatrix x, SubMatrix y) {
        if (this.m_nrows != this.m_ncols || x.m_nrows != x.m_ncols || y.m_nrows != y.m_ncols || this.m_nrows != x.m_nrows || this.m_nrows != y.m_nrows) {
            throw new MatrixException("m_err_dim");
        }
        DataBlock tmp = new DataBlock(this.m_nrows);
        DataBlockIterator mrows = this.rows();
        DataBlock mrow = mrows.getData();
        do {
            tmp.copy(mrow);
            mrow.product(tmp, y.columns());
        } while (mrows.next());
        DataBlockIterator mcols = this.columns();
        DataBlock mcol = mcols.getData();
        do {
            tmp.copy(mcol);
            mcol.product(x.rows(), tmp);
        } while (mcols.next());
    }

    public double nrm2() {
        if (this.isFull()) {
            return new DataBlock(this.m_data).nrm2();
        }
        DataBlockIterator columns = this.columns();
        DataBlock column = columns.getData();
        double n = column.nrm2();
        while (columns.next()) {
            DataBlock.hypot(n, column.nrm2());
        }
        return n;
    }

    public void next(int nrows, int ncols) {
        this.m_start += this.m_nrows * this.m_row_inc + this.m_ncols * this.m_col_inc;
        this.m_nrows = nrows;
        this.m_ncols = ncols;
    }

    public void next() {
        this.m_start += this.m_nrows * this.m_row_inc + this.m_ncols * this.m_col_inc;
    }

    public void hnext(int ncols) {
        this.m_start += this.m_ncols * this.m_col_inc;
        this.m_ncols = ncols;
    }

    public void hnext() {
        this.m_start += this.m_ncols * this.m_col_inc;
    }

    public void vnext(int nrows) {
        this.m_start += this.m_nrows * this.m_row_inc;
        this.m_nrows = nrows;
    }

    public void vnext() {
        this.m_start += this.m_nrows * this.m_row_inc;
    }

    public void previous(int nrows, int ncols) {
        this.m_start -= nrows * this.m_row_inc + ncols * this.m_col_inc;
        this.m_nrows = nrows;
        this.m_ncols = ncols;
    }

    public void previous() {
        this.m_start -= this.m_nrows * this.m_row_inc + this.m_ncols * this.m_col_inc;
    }

    public void hprevious(int ncols) {
        this.m_start -= ncols * this.m_col_inc;
        this.m_ncols = ncols;
    }

    public void hprevious() {
        this.m_start -= this.m_ncols * this.m_col_inc;
    }

    public void vprevious(int nrows) {
        this.m_start -= nrows * this.m_row_inc;
        this.m_nrows = nrows;
    }

    public void vprevious() {
        this.m_start -= this.m_nrows * this.m_row_inc;
    }

    public SubMatrix topLeft() {
        return new SubMatrix(this.m_data, this.m_start, 0, 0, this.m_row_inc, this.m_col_inc);
    }

    public SubMatrix topLeft(int nr, int nc) {
        return new SubMatrix(this.m_data, this.m_start, nr, nc, this.m_row_inc, this.m_col_inc);
    }

    public SubMatrix top(int nr) {
        return new SubMatrix(this.m_data, this.m_start, nr, this.m_ncols, this.m_row_inc, this.m_col_inc);
    }

    public SubMatrix left(int nc) {
        return new SubMatrix(this.m_data, this.m_start, this.m_nrows, nc, this.m_row_inc, this.m_col_inc);
    }

    public SubMatrix bottomRight() {
        int start = this.m_nrows * this.m_row_inc + this.m_ncols * this.m_col_inc;
        return new SubMatrix(this.m_data, start, 0, 0, this.m_row_inc, this.m_col_inc);
    }

    public SubMatrix bottomRight(int nr, int nc) {
        int start = (this.m_nrows - nr) * this.m_row_inc + (this.m_ncols - nc) * this.m_col_inc;
        return new SubMatrix(this.m_data, start, nr, nc, this.m_row_inc, this.m_col_inc);
    }

    public SubMatrix bottom(int nr) {
        return new SubMatrix(this.m_data, this.m_start + this.m_nrows - nr, nr, this.m_ncols, this.m_row_inc, this.m_col_inc);
    }

    public SubMatrix right(int nc) {
        return new SubMatrix(this.m_data, this.m_start + (this.m_ncols - nc) * this.m_col_inc, this.m_nrows, nc, this.m_row_inc, this.m_col_inc);
    }
}

