/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.IReadDataBlock;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;

public interface IDataBlock
extends IReadDataBlock {
    public void copyFrom(double[] var1, int var2);

    public IDataBlock extract(int var1, int var2);

    public void set(int var1, double var2);

    default public void apply(DoubleUnaryOperator fn) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            this.set(i, fn.applyAsDouble(this.get(i)));
        }
    }

    default public void applyIf(DoublePredicate pred, DoubleUnaryOperator fn) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            double cur = this.get(i);
            if (!pred.test(cur)) continue;
            this.set(i, fn.applyAsDouble(cur));
        }
    }

    default public void applyRecursively(double initial, DoubleBinaryOperator fn) {
        double cur = initial;
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            cur = fn.applyAsDouble(cur, this.get(i));
            this.set(i, cur);
        }
    }

    default public void apply(IReadDataBlock x, DoubleBinaryOperator fn) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            this.set(i, fn.applyAsDouble(this.get(i), x.get(i)));
        }
    }

    default public void copy(IReadDataBlock x) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            this.set(i, x.get(i));
        }
    }

    default public void set(DoubleSupplier fn) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            this.set(i, fn.getAsDouble());
        }
    }

    default public void setIf(DoublePredicate pred, DoubleSupplier fn) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            if (!pred.test(this.get(i))) continue;
            this.set(i, fn.getAsDouble());
        }
    }

    default public void set(IntToDoubleFunction fn) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            this.set(i, fn.applyAsDouble(i));
        }
    }

    default public void set(IReadDataBlock x, DoubleUnaryOperator fn) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            this.set(i, fn.applyAsDouble(x.get(i)));
        }
    }

    default public void set(IReadDataBlock x, IReadDataBlock y, DoubleBinaryOperator fn) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            this.set(i, fn.applyAsDouble(x.get(i), y.get(i)));
        }
    }
}

