/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.TsVariables;
import ec.tstoolkit.utilities.DefaultNameValidator;
import ec.tstoolkit.utilities.IModifiable;
import ec.tstoolkit.utilities.INameValidator;
import ec.tstoolkit.utilities.NameManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ProcessingContext
implements IModifiable {
    public static final String LEGACY = "legacy";
    private final HashMap<Class, NameManager> map_ = new HashMap();
    private static final ProcessingContext[] def_ = new ProcessingContext[]{new ProcessingContext()};

    public ProcessingContext() {
        this.map_.put(TsVariables.class, new NameManager<TsVariables>(TsVariables.class, "Variables_", new DefaultNameValidator(".")));
        this.map_.put(IGregorianCalendarProvider.class, new GregorianCalendarManager());
    }

    public GregorianCalendarManager getGregorianCalendars() {
        return (GregorianCalendarManager)this.map_.get(IGregorianCalendarProvider.class);
    }

    public NameManager<TsVariables> getTsVariableManagers() {
        return this.map_.get(TsVariables.class);
    }

    public TsVariables getTsVariables(String family) {
        NameManager obj = this.map_.get(TsVariables.class);
        if (obj == null) {
            return null;
        }
        NameManager mgr = obj;
        return (TsVariables)mgr.get(family);
    }

    public ITsVariable getTsVariable(String family, String var) {
        NameManager obj = this.map_.get(TsVariables.class);
        if (obj == null) {
            return null;
        }
        NameManager mgr = obj;
        TsVariables vars = (TsVariables)mgr.get(family);
        if (vars == null) {
            return null;
        }
        return (ITsVariable)vars.get(var);
    }

    public ITsVariable getTsVariable(String name) {
        String[] s = InformationSet.split(name);
        if (s.length == 1) {
            return this.getTsVariable(LEGACY, s[0]);
        }
        if (s.length != 2) {
            return null;
        }
        return this.getTsVariable(s[0], s[1]);
    }

    public List<String> getTsVariableDictionary() {
        ArrayList<String> all = new ArrayList<String>();
        NameManager<TsVariables> mgrs = this.getTsVariableManagers();
        String[] groups = mgrs.getNames();
        for (int i = 0; i < groups.length; ++i) {
            TsVariables tv = mgrs.get(groups[i]);
            String[] vars = tv.getNames();
            for (int j = 0; j < vars.length; ++j) {
                all.add(InformationSet.item(groups[i], vars[j]));
            }
        }
        return all;
    }

    public <T> boolean add(Class<T> tclass, String prefix, INameValidator validator) {
        if (this.map_.containsKey(tclass)) {
            return false;
        }
        this.map_.put(tclass, new NameManager<T>(tclass, prefix, validator));
        return true;
    }

    public Collection<Class> getTypes() {
        return this.map_.keySet();
    }

    public <T> NameManager<T> getInformation(Class<T> tclass) {
        return this.map_.get(tclass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessingContext getActiveContext() {
        ProcessingContext[] processingContextArray = def_;
        synchronized (def_) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return def_[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActiveContext(ProcessingContext context) {
        ProcessingContext[] processingContextArray = def_;
        synchronized (def_) {
            ProcessingContext.def_[0] = context;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isDirty() {
        for (NameManager mgr : this.map_.values()) {
            if (!mgr.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resetDirty() {
        for (NameManager mgr : this.map_.values()) {
            mgr.resetDirty();
        }
    }

    public void clear() {
        for (NameManager mgr : this.map_.values()) {
            mgr.clear();
        }
    }

    public void resetDefault() {
        this.map_.clear();
        this.map_.put(TsVariables.class, new NameManager<TsVariables>(TsVariables.class, "Variables_", new DefaultNameValidator(".")));
        this.map_.put(IGregorianCalendarProvider.class, new GregorianCalendarManager());
    }
}

