/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.DefaultSeasonalFilteringStrategy;
import ec.satoolkit.x11.DefaultTrendFilteringStrategy;
import ec.satoolkit.x11.INormalizing;
import ec.satoolkit.x11.MixedEndPoints;
import ec.satoolkit.x11.SeasonalFilterFactory;
import ec.satoolkit.x11.SeasonalFilterOption;
import ec.satoolkit.x11.TrendCycleFilterFactory;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class ComplexNormalizingStrategie
implements INormalizing {
    private SeasonalFilterOption[] options;

    public ComplexNormalizingStrategie(SeasonalFilterOption[] options) {
        this.options = options;
    }

    @Override
    public String getDescription() {
        return "Mixed Normalizer";
    }

    @Override
    public TsData process(TsData s, TsDomain domain, int freq) {
        SymmetricFilter f = TrendCycleFilterFactory.makeTrendFilter(freq);
        SeasonalFilterOption[] tempOptions = (SeasonalFilterOption[])this.options.clone();
        int ny_all = domain.getLength() / domain.getFrequency().intValue();
        int nyr_all = domain.getLength() % domain.getFrequency().intValue() == 0 ? ny_all : ny_all + 1;
        for (int p = 0; p < tempOptions.length; ++p) {
            int nf = 0;
            if (tempOptions[p] != null && tempOptions[p] != SeasonalFilterOption.Stable && tempOptions[p] != SeasonalFilterOption.Msr && tempOptions[p] != SeasonalFilterOption.X11Default) {
                DefaultSeasonalFilteringStrategy defaultFilteringStrategy = SeasonalFilterFactory.getDefaultFilteringStrategy(tempOptions[p]);
                SymmetricFilter sf = defaultFilteringStrategy.filter;
                nf = sf.getUpperBound();
            }
            if (tempOptions[p] != null && ny_all >= 5 && (nf < 8 || nyr_all >= 20)) continue;
            tempOptions[p] = SeasonalFilterOption.Stable;
        }
        MixedEndPoints iep = new MixedEndPoints(tempOptions, f.getLength() / 2, s.getStart().getPosition());
        DefaultTrendFilteringStrategy n = new DefaultTrendFilteringStrategy(f, iep);
        TsData tmp = n.process(s, s.getDomain());
        return tmp;
    }
}

