/*
 * Decompiled with CFR 0.152.
 */
package demetra.xml.algorithm;

import demetra.xml.IXmlConverter;
import demetra.xml.calendar.XmlCalendars;
import demetra.xml.regression.XmlTsVariables;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.timeseries.regression.TsVariables;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="processingContext")
@XmlType(name="processingContextType")
public class XmlProcessingContext
implements IXmlConverter<ProcessingContext> {
    static final String NAME = "processingContextType";
    static final String RNAME = "processingContext";
    @XmlElement(name="group")
    @XmlElementWrapper(name="variables")
    public XmlTsVariables[] tsVariables;
    @XmlElement
    public XmlCalendars calendars;

    @Override
    public ProcessingContext create() {
        ProcessingContext context = new ProcessingContext();
        if (this.calendars != null) {
            this.calendars.copyTo(context.getGregorianCalendars());
        }
        if (this.tsVariables != null) {
            for (int i = 0; i < this.tsVariables.length; ++i) {
                TsVariables var = this.tsVariables[i].create();
                if (var == null || this.tsVariables[i].name == null) continue;
                context.getTsVariableManagers().set(this.tsVariables[i].name, (Object)var);
            }
        }
        return context;
    }

    @Override
    public void copy(ProcessingContext t) {
        this.calendars = new XmlCalendars();
        this.calendars.copy(t.getGregorianCalendars());
        int count = t.getTsVariableManagers().getCount();
        if (count > 0) {
            this.tsVariables = new XmlTsVariables[count];
            int i = 0;
            for (String n : t.getTsVariableManagers().getNames()) {
                TsVariables cur = t.getTsVariables(n);
                XmlTsVariables xcur = new XmlTsVariables();
                xcur.name = n;
                xcur.copy(cur);
                this.tsVariables[i++] = xcur;
            }
        }
    }
}

