/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.StringFormatter;
import java.util.Objects;

public class Sequence
implements Cloneable {
    public Day start;
    public Day end;

    public String toString() {
        if (this.start.equals((Object)this.end)) {
            return this.start.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(StringFormatter.convert(this.start)).append('.').append(StringFormatter.convert(this.end));
        return builder.toString();
    }

    public String toString(TsFrequency freq) {
        TsPeriod pend = new TsPeriod(freq, this.end);
        TsPeriod pstart = new TsPeriod(freq, this.start);
        if (pend.equals(pstart)) {
            return pstart.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(pstart).append('.').append(pend);
        return builder.toString();
    }

    public Sequence() {
        this.end = this.start = Day.toDay();
    }

    public Sequence(Day s, Day e) {
        this.start = s;
        this.end = e;
    }

    public static Sequence fromString(String s) {
        String[] ss = InformationSet.split(s);
        if (ss.length != 2) {
            return null;
        }
        Day start = StringFormatter.convertDay(ss[0]);
        Day end = StringFormatter.convertDay(ss[1]);
        if (start != null && end != null) {
            return new Sequence(start, end);
        }
        return null;
    }

    public Sequence clone() {
        try {
            return (Sequence)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public Day getEnd() {
        return this.end;
    }

    public Day getStart() {
        return this.start;
    }

    public void setEnd(Day end) {
        this.end = end;
    }

    public void setStart(Day start) {
        this.start = start;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Sequence && this.equals((Sequence)obj);
    }

    private boolean equals(Sequence other) {
        return Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.start);
        hash = 53 * hash + Objects.hashCode(this.end);
        return hash;
    }
}

