/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.satoolkit.diagnostics.FTest;
import ec.satoolkit.diagnostics.FriedmanTest;
import ec.tstoolkit.modelling.arima.AbstractModelController;
import ec.tstoolkit.modelling.arima.ModelStatistics;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.ModelComparator;
import ec.tstoolkit.modelling.arima.tramo.SeasonalOverDifferencingTest;
import ec.tstoolkit.modelling.arima.tramo.SeasonalityTests;
import ec.tstoolkit.modelling.arima.tramo.SpectralPeaks;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class SeasonalityController
extends AbstractModelController {
    private FTest ftest_;
    private SeasonalityTests stests_;
    private ModelStatistics mstats_;

    @Override
    public ProcessingResult process(ModellingContext context) {
        if (!context.automodelling || context.description.getFrequency() == 1) {
            return ProcessingResult.Unprocessed;
        }
        ProcessingResult result = this.getReferenceModel() == null ? this.computeReferenceModel(context) : this.compareReferenceModels(context);
        return result;
    }

    private void computeSTests() {
        TsData lin = this.getReferenceModel().linearizedSeries(false);
        SarimaSpecification spec = this.getReferenceModel().description.getSpecification();
        int del = 1;
        this.stests_ = new SeasonalityTests();
        this.stests_.test(lin, del, true);
        this.mstats_ = new ModelStatistics(this.getReferenceModel());
    }

    private boolean hasSeasonality(ModellingContext context) {
        int n;
        FriedmanTest np;
        TsFrequency freq = this.stests_.getDifferencing().getOriginal().getFrequency();
        if (this.stests_ == null) {
            return false;
        }
        int score = 0;
        int nscore = 0;
        if (this.mstats_.seasLjungBoxPvalue < 0.01) {
            ++score;
            ++nscore;
        }
        if ((np = this.stests_.getNonParametricTest()) != null && np.isSignificant()) {
            ++score;
        }
        if (((n = this.stests_.getDifferencing().getDifferenced().getLength()) >= 80 || freq != TsFrequency.Monthly && n >= 60) && SpectralPeaks.hasSeasonalPeaks(this.stests_.getSpectralPeaks())) {
            ++score;
        }
        this.ftest_ = new FTest();
        this.ftest_.test(this.getReferenceModel().description);
        boolean fs = this.ftest_.getFTest().isSignificant();
        if (fs) {
            ++score;
            ++nscore;
        }
        context.originalSeasonalityTest = score;
        if (score > 1 || nscore > 0) {
            return true;
        }
        return fs || this.mstats_.seasLjungBoxPvalue < 0.01;
    }

    private ProcessingResult computeReferenceModel(ModellingContext context) {
        PreprocessingModel model = context.current(false);
        this.setReferenceModel(model);
        this.computeSTests();
        boolean seas = this.hasSeasonality(context);
        SarimaSpecification spec = model.description.getSpecification();
        boolean schanged = false;
        if (!seas && spec.hasSeasonalPart()) {
            spec.airline(false);
            spec.setBQ(1);
            schanged = true;
        } else if (!context.hasseas && seas) {
            context.hasseas = true;
            return ProcessingResult.Changed;
        }
        if (!context.hasseas && (this.mstats_.seasLjungBoxPvalue < 0.05 || this.mstats_.ljungBoxPvalue < 0.05)) {
            context.hasseas = true;
            spec.airline(false);
            spec.setBQ(1);
            schanged = true;
        }
        if (schanged) {
            ModellingContext ncontext = new ModellingContext();
            ncontext.description = context.description.clone();
            ncontext.description.setSpecification(spec);
            if (this.estimate(ncontext, false)) {
                this.transferInformation(ncontext, context);
                this.setReferenceModel(context.current(false));
                return ProcessingResult.Changed;
            }
        }
        return ProcessingResult.Unchanged;
    }

    private ProcessingResult compareReferenceModels(ModellingContext context) {
        PreprocessingModel cur;
        ModelComparator cmp;
        int icmp;
        PreprocessingModel refmodel = this.getReferenceModel();
        ModelComparator.Preference pref = ModelComparator.Preference.BIC;
        if (!refmodel.description.getSpecification().equals((Object)context.description.getSpecification())) {
            SeasonalOverDifferencingTest overseas = new SeasonalOverDifferencingTest();
            switch (overseas.test(context)) {
                case 1: {
                    pref = ModelComparator.Preference.First;
                    break;
                }
                case 2: {
                    pref = ModelComparator.Preference.Second;
                }
            }
        }
        if ((icmp = (cmp = new ModelComparator(pref)).compare(cur = context.current(false), refmodel)) < 0) {
            this.setReferenceModel(cur);
            return ProcessingResult.Unchanged;
        }
        if (icmp > 0) {
            context.description = refmodel.description.clone();
            context.estimation = refmodel.estimation;
            context.information.clear();
            if (refmodel.info_ != null) {
                context.information.copy(refmodel.info_);
            }
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unchanged;
    }
}

