/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.arima.tramo.TramoException;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.utilities.Jdk6;
import java.util.Map;
import java.util.Objects;

public class EstimateSpec
implements Cloneable,
InformationSetSerializable {
    public static final String SPAN = "span";
    public static final String EML = "eml";
    public static final String TOL = "tol";
    public static final String UBP = "ubp";
    private TsPeriodSelector span_ = new TsPeriodSelector();
    private boolean eml_ = true;
    private double tol_ = 1.0E-7;
    private double ubp_ = 0.96;
    public static final double DEF_TOL = 1.0E-7;
    public static final double DEF_UBP = 0.96;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, EML), Boolean.class);
        dic.put(InformationSet.item(prefix, TOL), Double.class);
        dic.put(InformationSet.item(prefix, UBP), Double.class);
        dic.put(InformationSet.item(prefix, SPAN), TsPeriodSelector.class);
    }

    public void reset() {
        this.span_ = new TsPeriodSelector();
        this.eml_ = true;
        this.tol_ = 1.0E-7;
        this.ubp_ = 0.96;
    }

    public TsPeriodSelector getSpan() {
        return this.span_;
    }

    public void setSpan(TsPeriodSelector span) {
        if (span == null) {
            this.span_.all();
        } else {
            this.span_ = span;
        }
    }

    public boolean isEML() {
        return this.eml_;
    }

    public void setEML(boolean value) {
        this.eml_ = value;
    }

    public double getTol() {
        return this.tol_;
    }

    public void setTol(double value) {
        if (value <= 0.0 || value > 0.01) {
            throw new TramoException("Invalid Tol parameter");
        }
        this.tol_ = value;
    }

    public double getUbp() {
        return this.ubp_;
    }

    public void setUbp(double value) {
        this.ubp_ = value;
    }

    public boolean isDefault() {
        return this.eml_ && this.tol_ == 1.0E-7 && this.ubp_ == 0.96 && this.span_.getType() == PeriodSelectorType.All;
    }

    public EstimateSpec clone() {
        try {
            EstimateSpec spec = (EstimateSpec)super.clone();
            spec.span_ = this.span_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 13 * hash + (this.eml_ ? 1 : 0);
        hash = 13 * hash + Jdk6.Double.hashCode(this.tol_);
        hash = 13 * hash + Jdk6.Double.hashCode(this.ubp_);
        return hash;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof EstimateSpec && this.equals((EstimateSpec)obj);
    }

    private boolean equals(EstimateSpec other) {
        return this.eml_ == other.eml_ && this.tol_ == other.tol_ && this.ubp_ == other.ubp_ && Objects.equals(other.span_, this.span_);
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.span_.getType() != PeriodSelectorType.All) {
            info.add(SPAN, this.span_);
        }
        if (verbose || !this.eml_) {
            info.add(EML, Boolean.valueOf(this.eml_));
        }
        if (verbose || this.tol_ != 1.0E-7) {
            info.add(TOL, Double.valueOf(this.tol_));
        }
        if (verbose || this.ubp_ != 0.96) {
            info.add(UBP, Double.valueOf(this.ubp_));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Boolean eml;
            Double ubp;
            Double tol;
            this.reset();
            TsPeriodSelector span = info.get(SPAN, TsPeriodSelector.class);
            if (span != null) {
                this.span_ = span;
            }
            if ((tol = info.get(TOL, Double.class)) != null) {
                this.tol_ = tol;
            }
            if ((ubp = info.get(UBP, Double.class)) != null) {
                this.ubp_ = ubp;
            }
            if ((eml = info.get(EML, Boolean.class)) != null) {
                this.eml_ = eml;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

