/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.SeriesInfo;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class ModellingDictionary {
    private static final HashMap<String, SeriesInfo> dictionary_ = new HashMap();
    public static final String DECOMPOSITION = "decomposition";
    public static final String PREPROCESSING = "preprocessing";
    public static final String DETAILS = "details";
    public static final String N = "n";
    public static final String SPAN = "span";
    public static final String Y = "y";
    public static final String T = "t";
    public static final String S = "s";
    public static final String SA = "sa";
    public static final String I = "i";
    public static final String YC = "yc";
    public static final String YCAL = "ycal";
    public static final String DET = "det";
    public static final String L = "l";
    public static final String MODE = "mode";
    public static final String[] ALL = new String[]{"mode", "y", "t", "s", "sa", "i"};
    public static final String Y_LIN = "y_lin";
    public static final String T_LIN = "t_lin";
    public static final String S_LIN = "s_lin";
    public static final String SA_LIN = "sa_lin";
    public static final String I_LIN = "i_lin";
    public static final String SI_LIN = "si_lin";
    public static final String[] ALL_LIN = new String[]{"y_lin", "t_lin", "s_lin", "sa_lin", "i_lin", "si_lin"};
    public static final String Y_CMP = "y_cmp";
    public static final String T_CMP = "t_cmp";
    public static final String S_CMP = "s_cmp";
    public static final String SA_CMP = "sa_cmp";
    public static final String I_CMP = "i_cmp";
    public static final String SI_CMP = "si_cmp";
    public static final String[] ALL_CMP = new String[]{"y_cmp", "t_cmp", "s_cmp", "sa_cmp", "i_cmp", "si_cmp"};
    public static final String CAL = "cal";
    public static final String EE = "ee";
    public static final String TDE = "tde";
    public static final String MHE = "mhe";
    public static final String RMDE = "rmde";
    public static final String OMHE = "omhe";
    public static final String[] ALL_MHE = new String[]{"ee", "rmde", "omhe"};
    public static final String OUT_I = "out_i";
    public static final String OUT_S = "out_s";
    public static final String OUT_T = "out_t";
    public static final String OUT = "out";
    public static final String[] ALL_OUT = new String[]{"out_i", "out_s", "out_t"};
    public static final String REG_I = "reg_i";
    public static final String REG_S = "reg_s";
    public static final String REG_T = "reg_t";
    public static final String REG_SA = "reg_sa";
    public static final String REG_Y = "reg_y";
    public static final String REG_U = "reg_u";
    public static final String REG = "reg";
    public static final String DET_I = "det_i";
    public static final String DET_S = "det_s";
    public static final String DET_T = "det_t";
    public static final String DET_SA = "det_sa";
    public static final String DET_Y = "det_y";
    public static final String[] ALL_REG = new String[]{"reg_i", "reg_s", "reg_t", "reg_sa", "reg_y"};
    public static final String FULL_RES = "full_res";
    private static final SeriesInfo[] finals_;
    private static SeriesInfo[] stoch_;
    private static SeriesInfo[] det_;
    private static SeriesInfo[] others_;

    private ModellingDictionary() {
    }

    public static void fillDictionary(List<SeriesInfo> sel, String prefix, List<String> dictionary) {
        if (sel == null) {
            sel = Jdk6.newArrayList(dictionary_.values());
        }
        if (prefix != null) {
            for (SeriesInfo info : sel) {
                dictionary.add(InformationSet.item(prefix, info.getCode()));
            }
        } else {
            for (SeriesInfo info : sel) {
                dictionary.add(info.getCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SeriesInfo getInfo(String code) {
        HashMap<String, SeriesInfo> hashMap = dictionary_;
        synchronized (hashMap) {
            return dictionary_.get(code);
        }
    }

    public static SeriesInfo getInfo(String code, ComponentInformation info) {
        SeriesInfo master = ModellingDictionary.getInfo(code);
        if (master == null) {
            return null;
        }
        if (info == ComponentInformation.Value) {
            return master;
        }
        SeriesInfo sinfo = new SeriesInfo(master.name, master.description, master.component, info);
        return sinfo;
    }

    public static List<SeriesInfo> getFinalSeries() {
        return Arrays.asList(finals_);
    }

    public static List<SeriesInfo> getMainSeries() {
        ArrayList<SeriesInfo> dic = new ArrayList<SeriesInfo>();
        dic.add(ModellingDictionary.getInfo(Y));
        dic.add(ModellingDictionary.getInfo(SA));
        dic.add(ModellingDictionary.getInfo(T));
        dic.add(ModellingDictionary.getInfo(S));
        dic.add(ModellingDictionary.getInfo(I));
        return dic;
    }

    public static List<SeriesInfo> getStochasticSeries() {
        return Arrays.asList(stoch_);
    }

    public static List<SeriesInfo> getDeterministicSeries() {
        return Arrays.asList(det_);
    }

    public static List<SeriesInfo> getOtherSeries() {
        return Arrays.asList(others_);
    }

    static {
        SeriesInfo info = new SeriesInfo(CAL, "Calendar effects", ComponentType.CalendarEffect, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(I, "Final irregular component", ComponentType.Irregular, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(S, "Final seasonal component", ComponentType.Seasonal, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(SA, "Final seasonally adjusted series", ComponentType.SeasonallyAdjusted, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(T, "Final trend component", ComponentType.Trend, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(EE, "Easter effect", ComponentType.CalendarEffect, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(TDE, "Trading days effect", ComponentType.CalendarEffect, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(MHE, "Moving holidays effect", ComponentType.CalendarEffect, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(RMDE, "Ramadan effect", ComponentType.CalendarEffect, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(OMHE, "Other moving holidays effects", ComponentType.CalendarEffect, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(OUT_I, "Outliers effect on the irregular component", ComponentType.Irregular, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(OUT_S, "Outliers effect on the seasonal component", ComponentType.Seasonal, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(OUT_T, "Outliers effect on the trend component", ComponentType.Seasonal, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(OUT, "Total outliers effect", ComponentType.Undefined, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(REG_I, "Regression effect on the irregular component", ComponentType.Irregular, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(REG_S, "Regression effect on the seasonal component", ComponentType.Seasonal, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(REG_SA, "Regression effect on the seasonally adjusted series", ComponentType.SeasonallyAdjusted, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(REG_T, "Regression effect on the trend component", ComponentType.Trend, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(REG, "Total regression effects", ComponentType.Undefined, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(REG_Y, "Separate regression effect", ComponentType.Series, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(I_CMP, "Irregular component", ComponentType.Irregular, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(S_CMP, "Seasonal component", ComponentType.Seasonal, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(SA_CMP, "Seasonally adjusted series", ComponentType.SeasonallyAdjusted, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(SI_CMP, "SI-Ratio", ComponentType.Undefined, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(T_CMP, "Trend", ComponentType.Trend, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(I_LIN, "Linearized irregular component", ComponentType.Irregular, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(S_LIN, "Linearized seasonal component", ComponentType.Seasonal, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(SA_LIN, "Linearized seasonally adjusted series", ComponentType.SeasonallyAdjusted, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(SI_LIN, "Linearized SI-Ratio", ComponentType.Undefined, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(T_LIN, "Linearized trend", ComponentType.Trend, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(Y, "Original series", ComponentType.Series, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(YC, "Interpolated series", ComponentType.Series, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(YCAL, "Series corrected for the calendar effects", ComponentType.Series, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(Y_CMP, "Series component", ComponentType.Series, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(Y_LIN, "Linearized series", ComponentType.Series, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(DET, "Deterministic component", ComponentType.Undefined, true);
        dictionary_.put(info.name, info);
        info = new SeriesInfo(L, "[Log-transformed] linearized series", ComponentType.Series, true);
        dictionary_.put(info.name, info);
        finals_ = new SeriesInfo[]{ModellingDictionary.getInfo(Y), ModellingDictionary.getInfo(SA), ModellingDictionary.getInfo(T), ModellingDictionary.getInfo(S), ModellingDictionary.getInfo(I), ModellingDictionary.getInfo(Y, ComponentInformation.Forecast), ModellingDictionary.getInfo(Y, ComponentInformation.StdevForecast), ModellingDictionary.getInfo(SA, ComponentInformation.Forecast), ModellingDictionary.getInfo(T, ComponentInformation.Forecast), ModellingDictionary.getInfo(S, ComponentInformation.Forecast), ModellingDictionary.getInfo(I, ComponentInformation.Forecast)};
        stoch_ = new SeriesInfo[]{ModellingDictionary.getInfo(Y_LIN), ModellingDictionary.getInfo(SA_LIN), ModellingDictionary.getInfo(T_LIN), ModellingDictionary.getInfo(S_LIN), ModellingDictionary.getInfo(I_LIN), ModellingDictionary.getInfo(SA_LIN, ComponentInformation.Forecast), ModellingDictionary.getInfo(T_LIN, ComponentInformation.Forecast), ModellingDictionary.getInfo(S_LIN, ComponentInformation.Forecast), ModellingDictionary.getInfo(I_LIN, ComponentInformation.Forecast), ModellingDictionary.getInfo(SA_LIN, ComponentInformation.StdevForecast), ModellingDictionary.getInfo(T_LIN, ComponentInformation.StdevForecast), ModellingDictionary.getInfo(S_LIN, ComponentInformation.StdevForecast), ModellingDictionary.getInfo(I_LIN, ComponentInformation.StdevForecast)};
        det_ = new SeriesInfo[]{ModellingDictionary.getInfo(YC), ModellingDictionary.getInfo(Y_LIN), ModellingDictionary.getInfo(YCAL), ModellingDictionary.getInfo(DET), ModellingDictionary.getInfo(CAL), ModellingDictionary.getInfo(OMHE), ModellingDictionary.getInfo(RMDE), ModellingDictionary.getInfo(TDE), ModellingDictionary.getInfo(EE), ModellingDictionary.getInfo(OUT_T), ModellingDictionary.getInfo(OUT_S), ModellingDictionary.getInfo(OUT_I), ModellingDictionary.getInfo(OUT), ModellingDictionary.getInfo(REG_Y), ModellingDictionary.getInfo(REG_SA), ModellingDictionary.getInfo(REG_T), ModellingDictionary.getInfo(REG_S), ModellingDictionary.getInfo(REG_I), ModellingDictionary.getInfo(REG)};
        others_ = new SeriesInfo[]{new SeriesInfo(FULL_RES, "White-noise residuals")};
    }
}

