/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions.bfgs;

import ec.tstoolkit.maths.realfunctions.bfgs.ILineFunction;
import ec.tstoolkit.maths.realfunctions.bfgs.ILineSearch;

public class SimpleLineSearch
implements ILineSearch {
    private double m_eps = 1.0E-9;
    private double m_fac = 0.5;

    @Override
    public ILineSearch exemplar() {
        SimpleLineSearch ls = new SimpleLineSearch();
        return ls;
    }

    @Override
    public boolean optimize(ILineFunction fn, double start) {
        double stpmax = fn.getStepMax();
        if (stpmax < this.m_eps) {
            return true;
        }
        double stp = start;
        if (stp > stpmax) {
            stp = stpmax;
        }
        double f0 = fn.getValue();
        do {
            try {
                fn.setStep(stp);
                if (fn.getValue() < f0) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while ((stp *= this.m_fac) > this.m_eps);
        return false;
    }
}

