/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.polynomials;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.polynomials.IRootsSolver;
import ec.tstoolkit.maths.polynomials.MullerNewtonSolver;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;

public class ChainedRootsSearcher
implements IRootsSolver {
    private final Stack<IRootsSolver> m_rootfinders = new Stack();
    private Complex[] m_roots;
    private Polynomial m_remainder;

    public ChainedRootsSearcher() {
        this.m_rootfinders.push(new MullerNewtonSolver());
    }

    public ChainedRootsSearcher(IRootsSolver baseFinder) {
        this.m_rootfinders.push(baseFinder);
    }

    public void add(IRootsSolver rf) {
        this.m_rootfinders.push(rf);
    }

    @Override
    public void clear() {
        this.m_roots = null;
        this.m_remainder = null;
        for (IRootsSolver searcher : this.m_rootfinders) {
            searcher.clear();
        }
    }

    @Override
    public boolean factorize(Polynomial p) {
        this.m_remainder = p;
        ArrayList al = new ArrayList(p.getDegree());
        for (int i = this.m_rootfinders.size() - 1; i >= 0 && this.m_remainder.getDegree() > 0; --i) {
            if (!((IRootsSolver)this.m_rootfinders.get(i)).factorize(this.m_remainder)) continue;
            Complex[] r = ((IRootsSolver)this.m_rootfinders.get(i)).roots();
            if (r != null && r.length != 0) {
                Collections.addAll(al, r);
            }
            this.m_remainder = ((IRootsSolver)this.m_rootfinders.get(i)).remainder();
        }
        if (!al.isEmpty()) {
            this.m_roots = Jdk6.Collections.toArray(al, Complex.class);
            return true;
        }
        return false;
    }

    public void pop() {
        this.m_rootfinders.pop();
    }

    public void pop(IRootsSolver rf) {
        IRootsSolver r = this.m_rootfinders.peek();
        if (r.getClass().equals(rf.getClass())) {
            this.m_rootfinders.pop();
        }
    }

    @Override
    public Polynomial remainder() {
        return this.m_remainder;
    }

    @Override
    public Complex[] roots() {
        return this.m_roots;
    }

    @Override
    public ChainedRootsSearcher exemplar() {
        ChainedRootsSearcher solver = new ChainedRootsSearcher(((IRootsSolver)this.m_rootfinders.get(0)).exemplar());
        for (int i = 1; i < this.m_rootfinders.size(); ++i) {
            solver.add(((IRootsSolver)this.m_rootfinders.get(i)).exemplar());
        }
        return solver;
    }
}

