/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special.mixedfrequencies;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.arima.special.mixedfrequencies.MixedFrequenciesMonitor;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.DeterministicComponent;
import ec.tstoolkit.modelling.arima.LogForecasts;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.stats.NiidTests;
import ec.tstoolkit.timeseries.DataType;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.regression.DiffConstant;
import ec.tstoolkit.timeseries.regression.ICalendarVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class MixedFrequenciesModelEstimation
implements IProcResults {
    private double logtransform;
    private final SarimaModel arima;
    private final Matrix X;
    private final Matrix J;
    private final ConcentratedLikelihood likelihood;
    private LikelihoodStatistics statistics;
    private NiidTests tests;
    private final Matrix pcov;
    private final TsVariableList regs;
    private final TsData h0;
    private final TsData l0;
    private final TsData he;
    private final TsData le;
    private final TsData si;
    private final TsData esi;
    private final TsDomain edomain;
    private final DataType type;
    private final boolean log;
    public static final String LIKELIHOOD = "likelihood";
    public static final String NP = "np";
    public static final String NEFFOBS = "neffectiveobs";
    public static final String ADJLVAL = "adjustedlogvalue";
    public static final String LVAL = "logvalue";
    public static final String SSQERR = "ssqerr";
    public static final String SER = "ser";
    public static final String SERML = "ser-ml";
    public static final String AIC = "aic";
    public static final String AICC = "aicc";
    public static final String BIC = "bic";
    public static final String BICC = "bicc";
    public static final String RESIDUALS = "residuals";
    public static final String RES_DATA = "res";
    public static final String RES_STDERR = "stderr";
    public static final String RES_MEAN = "mean";
    public static final String RES_SKEWNESS = "skewness";
    public static final String RES_KURTOSIS = "kurtosis";
    public static final String RES_DH = "dh";
    public static final String RES_LB = "lb";
    public static final String RES_LB2 = "lb2";
    public static final String RES_SEASLB = "seaslb";
    public static final String RES_BP = "bp";
    public static final String RES_BP2 = "bp2";
    public static final String RES_SEASBP = "seasbp";
    public static final String RES_UD_NUMBER = "nruns";
    public static final String RES_UD_LENGTH = "lruns";
    public static final String ARIMA = "arima";
    public static final String ARIMA_COVAR = "covar";
    public static final String ARIMA_MEAN = "mean";
    public static final String ARIMA_P = "p";
    public static final String ARIMA_D = "d";
    public static final String ARIMA_Q = "q";
    public static final String ARIMA_BP = "bp";
    public static final String ARIMA_BD = "bd";
    public static final String ARIMA_BQ = "bq";
    public static final String ARIMA_PHI = "phi";
    public static final String ARIMA_PHI1 = "phi(1)";
    public static final String ARIMA_PHI2 = "phi(2)";
    public static final String ARIMA_PHI3 = "phi(3)";
    public static final String ARIMA_PHI4 = "phi(4)";
    public static final String ARIMA_TH = "th";
    public static final String ARIMA_TH1 = "th(1)";
    public static final String ARIMA_TH2 = "th(2)";
    public static final String ARIMA_TH3 = "th(3)";
    public static final String ARIMA_TH4 = "th(4)";
    public static final String ARIMA_BPHI = "bphi";
    public static final String ARIMA_BPHI1 = "bphi(1)";
    public static final String ARIMA_BTH = "bth";
    public static final String ARIMA_BTH1 = "bth(1)";
    public static final String YC = "yc";
    public static final String YC_E = "yc_e";
    public static final String YC_L = "yc_orig";
    public static final String YC_L_E = "yc_orig_e";
    private static final InformationMapping<MixedFrequenciesModelEstimation> MAPPING = new InformationMapping<MixedFrequenciesModelEstimation>(MixedFrequenciesModelEstimation.class);

    public MixedFrequenciesModelEstimation(MixedFrequenciesMonitor monitor, DataType type, boolean log) {
        this.type = type;
        this.X = monitor.getX();
        this.J = monitor.getJ();
        this.regs = monitor.getRegression();
        this.arima = monitor.getArima();
        this.edomain = monitor.getEstimationDomain();
        this.h0 = monitor.getHighFreqInput();
        this.l0 = monitor.getLowFreqInput();
        this.he = monitor.getHighFreqData();
        this.le = monitor.getLowFreqData();
        this.likelihood = monitor.getLikelihood();
        this.pcov = monitor.getParametersCovariance();
        this.si = monitor.getInterpolatedSeries();
        this.esi = monitor.getInterpolationErrors();
        this.log = log;
    }

    public void setLogTransformation(double val) {
        this.logtransform = val;
    }

    public boolean isLog() {
        return this.log;
    }

    public TsData getHighFreqInput() {
        return this.h0;
    }

    public TsData getLowFreqInput() {
        return this.l0;
    }

    public TsData getHighFreqData() {
        return this.he;
    }

    public TsData getLowFreqData() {
        return this.le;
    }

    public TsData getInterpolatedSeries(boolean transformed) {
        if (this.log && !transformed) {
            return this.si.exp();
        }
        if (!this.log && transformed) {
            return null;
        }
        return this.si;
    }

    public TsData getInterpolationErrors(boolean transformed) {
        if (this.log && !transformed) {
            TsData esic = this.esi.clone();
            for (int i = 0; i < esic.getLength(); ++i) {
                esic.set(i, LogForecasts.expStdev(this.esi.get(i), this.si.get(i)));
            }
            return esic;
        }
        if (!this.log && transformed) {
            return null;
        }
        return this.esi;
    }

    public ConcentratedLikelihood getLikelihood() {
        return this.likelihood;
    }

    public LikelihoodStatistics getLikelihoodStatistics() {
        if (this.statistics == null) {
            int n = this.le.getObsCount() + this.he.getObsCount();
            this.statistics = LikelihoodStatistics.create(this.likelihood, n - this.arima.getDifferenceOrder(), this.arima.getParametersCount(), this.logtransform);
        }
        return this.statistics;
    }

    public Matrix getX() {
        return this.X;
    }

    public Matrix getJ() {
        return this.J;
    }

    public TsVariableList getRegression() {
        return this.regs;
    }

    public SarimaModel getArima() {
        return this.arima;
    }

    public Matrix getParametersCovariance() {
        return this.pcov;
    }

    private TsData op(TsData l, TsData r) {
        if (this.log) {
            return TsData.multiply(l, r);
        }
        return TsData.add(l, r);
    }

    private TsData inv_op(TsData l, TsData r) {
        if (this.log) {
            return TsData.divide(l, r);
        }
        return TsData.subtract(l, r);
    }

    public TsData linearizedSeries() {
        TsData sregs = this.regressionEffect(this.edomain);
        return TsData.subtract(this.si, sregs);
    }

    public TsData getHighFreqLinearizedSeries() {
        TsData sregs = this.regressionEffect(this.h0.getDomain());
        if (sregs != null && this.log) {
            sregs = sregs.exp();
        }
        return this.inv_op(this.h0, sregs);
    }

    public TsData getLowFreqLinearizedSeries() {
        TsDomain ldom = this.l0.getDomain().changeFrequency(this.h0.getFrequency(), true);
        TsData sregs = this.regressionEffect(ldom);
        if (sregs != null) {
            if (this.type == DataType.Stock) {
                sregs = sregs.changeFrequency(this.l0.getFrequency(), TsAggregationType.Last, true);
            } else {
                sregs = sregs.changeFrequency(this.l0.getFrequency(), TsAggregationType.Sum, true);
                if (this.log) {
                    sregs.apply(x -> x / (double)this.edomain.getFrequency().ratio(this.l0.getFrequency()));
                }
            }
        }
        if (sregs != null && this.log) {
            sregs = sregs.exp();
        }
        return this.inv_op(this.l0, sregs);
    }

    public TsData regressionEffect(TsDomain domain) {
        if (this.likelihood == null) {
            return null;
        }
        double[] coeffs = this.likelihood.getB();
        if (coeffs == null) {
            return new TsData(domain, 0.0);
        }
        TsVariableSelection<ITsVariable> sel = this.regs.select(var -> !(var instanceof DiffConstant));
        DataBlock sum = sel.sum(new DataBlock(coeffs, 0, coeffs.length, 1), domain);
        if (sum == null) {
            sum = new DataBlock(domain.getLength());
        }
        TsData rslt = new TsData(domain.getStart(), sum.getData(), false);
        return rslt;
    }

    public <T extends ITsVariable> TsData regressionEffect(TsDomain domain, Class<T> tclass) {
        if (this.likelihood == null) {
            return null;
        }
        double[] coeffs = this.likelihood.getB();
        if (coeffs == null) {
            return new TsData(domain, 0.0);
        }
        TsVariableSelection<ITsVariable> sel = this.regs.selectCompatible(tclass);
        if (sel.isEmpty()) {
            return new TsData(domain, 0.0);
        }
        DataBlock sum = sel.sum(new DataBlock(coeffs, 0, coeffs.length, 1), domain);
        if (sum == null) {
            sum = new DataBlock(domain.getLength());
        }
        TsData rslt = new TsData(domain.getStart(), sum.getData(), false);
        return rslt;
    }

    public TsData regressionEffect(TsDomain domain, ComponentType type) {
        return this.regressionEffect(domain, (ITsVariable var) -> !(var instanceof DiffConstant) && DeterministicComponent.getType(var) == type);
    }

    private TsDomain fdomain() {
        return new TsDomain(this.edomain.getEnd(), this.edomain.getFrequency().intValue());
    }

    private TsData regressionEffect(TsDomain domain, Predicate<ITsVariable> selector) {
        if (this.likelihood == null) {
            return null;
        }
        if (this.regs.isEmpty()) {
            return new TsData(domain, 0.0);
        }
        TsVariableSelection<ITsVariable> sel = this.regs.select(selector);
        if (sel.isEmpty()) {
            return new TsData(domain, 0.0);
        }
        double[] coeffs = this.likelihood.getB();
        DataBlock sum = sel.sum(new DataBlock(coeffs, 0, coeffs.length, 1), domain);
        if (sum == null) {
            sum = new DataBlock(domain.getLength());
        }
        TsData rslt = new TsData(domain.getStart(), sum.getData(), false);
        return rslt;
    }

    public TsData tradingDaysEffect(TsDomain domain) {
        return this.regressionEffect(domain, ICalendarVariable.class);
    }

    public TsData movingHolidaysEffect(TsDomain domain) {
        return this.regressionEffect(domain, IMovingHolidayVariable.class);
    }

    public TsData outliersEffect(TsDomain domain) {
        return this.regressionEffect(domain, IOutlierVariable.class);
    }

    public TsData outliersEffect(TsDomain domain, ComponentType type) {
        if (this.likelihood == null) {
            return null;
        }
        if (type == ComponentType.Undefined) {
            return this.outliersEffect(domain);
        }
        OutlierType[] types = PreprocessingModel.outlierTypes(type);
        TsData rslt = null;
        for (int i = 0; i < types.length; ++i) {
            double[] coeffs;
            DataBlock sum;
            TsVariableSelection<IOutlierVariable> sel = this.regs.select(types[i]);
            if (sel.isEmpty() || (sum = sel.sum(new DataBlock(coeffs = this.likelihood.getB(), 0, coeffs.length, 1), domain)) == null) continue;
            rslt = TsData.add(rslt, new TsData(domain.getStart(), sum.getData(), false));
        }
        return rslt;
    }

    public List<TsData> regressors(TsDomain domain) {
        ArrayList<TsData> vregs = new ArrayList<TsData>();
        List<DataBlock> data = this.regs.all().data(domain);
        for (DataBlock d : data) {
            double[] cur = new double[domain.getLength()];
            d.copyTo(cur, 0);
            vregs.add(new TsData(domain.getStart(), cur, false));
        }
        return vregs;
    }

    public static void fillDictionary(String prefix, Map<String, Class> map, boolean compact) {
        MAPPING.fillDictionary(prefix, map, compact);
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        MixedFrequenciesModelEstimation.fillDictionary(null, map, false);
        return map;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        return MAPPING.getData(this, id, tclass);
    }

    @Override
    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.EMPTY_LIST;
    }

    public static InformationMapping<MixedFrequenciesModelEstimation> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<MixedFrequenciesModelEstimation, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<MixedFrequenciesModelEstimation, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    private static Parameter param(MixedFrequenciesModelEstimation source, String name, int lag) {
        SarimaModel arima = source.getArima();
        int pos = -1;
        switch (name) {
            case "phi": {
                pos = arima.getPhiPosition(lag);
                break;
            }
            case "bphi": {
                pos = arima.getBPhiPosition(lag);
                break;
            }
            case "th": {
                pos = arima.getThetaPosition(lag);
                break;
            }
            case "bth": {
                pos = arima.getBThetaPosition(lag);
                break;
            }
        }
        if (pos < 0) {
            return null;
        }
        double err = source.pcov == null ? 0.0 : Math.sqrt(source.pcov.get(pos, pos));
        Parameter p = new Parameter(arima.getParameter(pos), err == 0.0 ? ParameterType.Fixed : ParameterType.Estimated);
        p.setStde(err);
        return p;
    }

    static {
        MAPPING.set(YC, source -> source.getInterpolatedSeries(false));
        MAPPING.set(YC_E, source -> source.getInterpolationErrors(false));
        MAPPING.set(YC_L, source -> source.getInterpolatedSeries(true));
        MAPPING.set(YC_L_E, source -> source.getInterpolationErrors(true));
        MAPPING.set("y_lin", source -> {
            TsData s = source.linearizedSeries();
            if (s == null) {
                return null;
            }
            if (source.log) {
                return s.exp();
            }
            return s;
        });
        MAPPING.set("cal", source -> {
            TsData s = source.regressionEffect(source.edomain, ComponentType.CalendarEffect);
            if (s == null) {
                return null;
            }
            if (source.log) {
                return s.exp();
            }
            return s;
        });
        MAPPING.set("det", source -> {
            TsData s = source.regressionEffect(source.edomain);
            if (s == null) {
                return null;
            }
            if (source.log) {
                return s.exp();
            }
            return s;
        });
        MAPPING.set("tde", source -> {
            TsData s = source.tradingDaysEffect(source.edomain);
            if (s == null) {
                return null;
            }
            if (source.log) {
                return s.exp();
            }
            return s;
        });
        MAPPING.set("ee", source -> {
            TsData s = source.movingHolidaysEffect(source.edomain);
            if (s == null) {
                return null;
            }
            if (source.log) {
                return s.exp();
            }
            return s;
        });
        MAPPING.set("cal_f", source -> {
            TsData s = source.regressionEffect(source.fdomain(), ComponentType.CalendarEffect);
            if (s == null) {
                return null;
            }
            if (source.log) {
                return s.exp();
            }
            return s;
        });
        MAPPING.set("det_f", source -> {
            TsData s = source.regressionEffect(source.fdomain());
            if (s == null) {
                return null;
            }
            if (source.log) {
                return s.exp();
            }
            return s;
        });
        MAPPING.set("tde_f", source -> {
            TsData s = source.tradingDaysEffect(source.fdomain());
            if (s == null) {
                return null;
            }
            if (source.log) {
                return s.exp();
            }
            return s;
        });
        MAPPING.set("ee_f", source -> {
            TsData s = source.movingHolidaysEffect(source.fdomain());
            if (s == null) {
                return null;
            }
            if (source.log) {
                return s.exp();
            }
            return s;
        });
        MAPPING.set(InformationSet.item(LIKELIHOOD, NEFFOBS), Integer.class, source -> source.statistics.effectiveObservationsCount);
        MAPPING.set(InformationSet.item(LIKELIHOOD, NP), Integer.class, source -> source.statistics.estimatedParametersCount);
        MAPPING.set(InformationSet.item(LIKELIHOOD, LVAL), Double.class, source -> source.statistics.logLikelihood);
        MAPPING.set(InformationSet.item(LIKELIHOOD, ADJLVAL), Double.class, source -> source.statistics.adjustedLogLikelihood);
        MAPPING.set(InformationSet.item(LIKELIHOOD, SSQERR), Double.class, source -> source.statistics.SsqErr);
        MAPPING.set(InformationSet.item(LIKELIHOOD, AIC), Double.class, source -> source.statistics.AIC);
        MAPPING.set(InformationSet.item(LIKELIHOOD, AICC), Double.class, source -> source.statistics.AICC);
        MAPPING.set(InformationSet.item(LIKELIHOOD, BIC), Double.class, source -> source.statistics.BIC);
        MAPPING.set(InformationSet.item(LIKELIHOOD, BICC), Double.class, source -> source.statistics.BICC);
        MAPPING.set(InformationSet.item(RESIDUALS, SER), Double.class, source -> Math.sqrt(source.statistics.SsqErr / (double)(source.statistics.effectiveObservationsCount - source.statistics.estimatedParametersCount + 1)));
        MAPPING.set(InformationSet.item(RESIDUALS, SERML), Double.class, source -> Math.sqrt(source.statistics.SsqErr / (double)source.statistics.effectiveObservationsCount));
        MAPPING.set(InformationSet.item(RESIDUALS, RES_DATA), double[].class, source -> source.likelihood.getResiduals());
        MAPPING.set(ARIMA, SarimaModel.class, source -> source.arima);
        MAPPING.set(InformationSet.item(ARIMA, ARIMA_P), Integer.class, source -> source.arima.getRegularAROrder());
        MAPPING.set(InformationSet.item(ARIMA, ARIMA_D), Integer.class, source -> source.arima.getRegularDifferenceOrder());
        MAPPING.set(InformationSet.item(ARIMA, ARIMA_Q), Integer.class, source -> source.arima.getRegularMAOrder());
        MAPPING.set(InformationSet.item(ARIMA, "bp"), Integer.class, source -> source.arima.getSeasonalAROrder());
        MAPPING.set(InformationSet.item(ARIMA, ARIMA_BD), Integer.class, source -> source.arima.getSeasonalDifferenceOrder());
        MAPPING.set(InformationSet.item(ARIMA, ARIMA_BQ), Integer.class, source -> source.arima.getSeasonalMAOrder());
        MAPPING.setList(InformationSet.item(ARIMA, ARIMA_PHI), 1, 5, Parameter.class, (source, i) -> MixedFrequenciesModelEstimation.param(source, ARIMA_PHI, i));
        MAPPING.setList(InformationSet.item(ARIMA, ARIMA_BPHI), 1, 2, Parameter.class, (source, i) -> MixedFrequenciesModelEstimation.param(source, ARIMA_BPHI, i));
        MAPPING.setList(InformationSet.item(ARIMA, ARIMA_TH), 1, 5, Parameter.class, (source, i) -> MixedFrequenciesModelEstimation.param(source, ARIMA_TH, i));
        MAPPING.setList(InformationSet.item(ARIMA, ARIMA_BTH), 1, 2, Parameter.class, (source, i) -> MixedFrequenciesModelEstimation.param(source, ARIMA_BTH, i));
        MAPPING.set(InformationSet.item(ARIMA, ARIMA_COVAR), Matrix.class, source -> source.pcov);
    }
}

