/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima;

import ec.tstoolkit.arima.AbstractLinearModel;
import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.AutoCovarianceFunction;
import ec.tstoolkit.arima.Spectrum;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.IRationalFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.matrices.Matrix;

public abstract class AbstractArimaModel
extends AbstractLinearModel {
    protected RationalBackFilter m_pi;
    protected RationalBackFilter m_psi;

    protected AbstractArimaModel() {
    }

    protected AbstractArimaModel(AbstractArimaModel m) {
        super(m);
        this.m_pi = m.m_pi;
        this.m_psi = m.m_psi;
    }

    @Override
    protected void clearCachedObjects() {
        super.clearCachedObjects();
        this.m_pi = null;
        this.m_psi = null;
    }

    public abstract BackFilter getAR();

    @Override
    public IRationalFilter getFilter() throws ArimaException {
        return this.getPsiWeights();
    }

    public abstract BackFilter getMA() throws ArimaException;

    public RationalBackFilter getPiWeights() throws ArimaException {
        if (this.m_pi == null) {
            this.m_pi = this.initPi();
        }
        return this.m_pi;
    }

    public RationalBackFilter getPsiWeights() throws ArimaException {
        if (this.m_psi == null) {
            this.m_psi = this.initPsi();
        }
        return this.m_psi;
    }

    @Override
    protected AutoCovarianceFunction initAcgf() throws ArimaException {
        return new AutoCovarianceFunction(this.getMA().getPolynomial(), this.getAR().getPolynomial(), this.getInnovationVariance());
    }

    protected RationalBackFilter initPi() throws ArimaException {
        return new RationalBackFilter(this.getAR(), this.getMA());
    }

    protected RationalBackFilter initPsi() throws ArimaException {
        return new RationalBackFilter(this.getMA(), this.getAR());
    }

    @Override
    protected Spectrum initSpectrum() throws ArimaException {
        return new Spectrum(SymmetricFilter.createFromFilter(this.getMA()).times(this.getInnovationVariance()), SymmetricFilter.createFromFilter(this.getAR()));
    }

    public String toString() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("AR = ").append(this.getAR().toString()).append("; ");
            builder.append("MA = ").append(this.getMA().toString()).append("; ");
            builder.append("var =").append(this.getInnovationVariance());
            return builder.toString();
        }
        catch (ArimaException ex) {
            return "Invalid model";
        }
    }

    public Matrix covariance(int n) {
        if (!this.isStationary()) {
            return null;
        }
        AutoCovarianceFunction acf = this.getAutoCovarianceFunction();
        Matrix V = new Matrix(n, n);
        acf.prepare(n - 1);
        V.diagonal().set(acf.get(0));
        for (int i = 1; i < n; ++i) {
            double w = acf.get(i);
            V.subDiagonal(i).set(w);
            V.subDiagonal(-i).set(w);
        }
        return V;
    }
}

