/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.ISeriesDecomposer;
import ec.satoolkit.x11.CochranDependentExtremeValuesCorrector;
import ec.satoolkit.x11.ICRatioComputer;
import ec.satoolkit.x11.IExtremeValuesCorrector;
import ec.satoolkit.x11.IX11Toolkit;
import ec.satoolkit.x11.PeriodSpecificExtremeValuesCorrector;
import ec.satoolkit.x11.X11Context;
import ec.satoolkit.x11.X11Results;
import ec.satoolkit.x11.X11Specification;
import ec.satoolkit.x11.X11Step;
import ec.satoolkit.x11.X11Toolkit;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class X11Kernel
implements ISeriesDecomposer {
    public static final String A = "a-tables";
    public static final String B = "b-tables";
    public static final String C = "c-tables";
    public static final String D = "d-tables";
    public static final String E = "e-tables";
    public static final String F = "f-tables";
    public static final String A1 = "a1";
    public static final String A1a = "a1a";
    public static final String A1b = "a1b";
    public static final String A6 = "a6";
    public static final String A7 = "a7";
    public static final String A8 = "a8";
    public static final String A8t = "a8t";
    public static final String A8s = "a8s";
    public static final String A8i = "a8i";
    public static final String A9 = "a9";
    public static final String A9u = "a9u";
    public static final String A9sa = "a9sa";
    public static final String A9ser = "a9ser";
    public static final String[] ALL_A = new String[]{"a1", "a1a", "a1b", "a6", "a7", "a8", "a8t", "a8s", "a8i", "a9", "a9sa", "a9u", "a9ser"};
    public static final String B1 = "b1";
    public static final String B2 = "b2";
    public static final String B3 = "b3";
    public static final String B3TEST = "b3-seasonalityTest";
    public static final String B4 = "b4";
    public static final String B5 = "b5";
    public static final String B6 = "b6";
    public static final String B7 = "b7";
    public static final String B7_IC = "b7-IC ratio";
    public static final String B8 = "b8";
    public static final String B9 = "b9";
    public static final String B10 = "b10";
    public static final String B11 = "b11";
    public static final String B12 = "b12";
    public static final String B13 = "b13";
    public static final String B14 = "b14";
    public static final String B15 = "b15";
    public static final String B16 = "b16";
    public static final String B17 = "b17";
    public static final String B18 = "b18";
    public static final String B19 = "b19";
    public static final String B20 = "b20";
    public static final String[] ALL_B = new String[]{"b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "b10", "b11", "b12", "b13", "b14", "b15", "b16", "b17", "b18", "b19", "b20"};
    public static final String C1 = "c1";
    public static final String C2 = "c2";
    public static final String C3 = "c3";
    public static final String C3TEST = "c3-seasonalityTest";
    public static final String C4 = "c4";
    public static final String C5 = "c5";
    public static final String C6 = "c6";
    public static final String C7 = "c7";
    public static final String C7_IC = "c7-IC ratio";
    public static final String C8 = "c8";
    public static final String C9 = "c9";
    public static final String C10 = "c10";
    public static final String C11 = "c11";
    public static final String C12 = "c12";
    public static final String C13 = "c13";
    public static final String C14 = "c14";
    public static final String C15 = "c15";
    public static final String C16 = "c16";
    public static final String C17 = "c17";
    public static final String C18 = "c18";
    public static final String C19 = "c19";
    public static final String C20 = "c20";
    public static final String[] ALL_C = new String[]{"c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "c10", "c11", "c12", "c13", "c14", "c15", "c16", "c17", "c18", "c19", "c20"};
    public static final String D1 = "d1";
    public static final String D2 = "d2";
    public static final String D3 = "d3";
    public static final String D3TEST = "d3-seasonalityTest";
    public static final String D4 = "d4";
    public static final String D5 = "d5";
    public static final String D6 = "d6";
    public static final String D7 = "d7";
    public static final String D7_IC = "d7-IC ratio";
    public static final String D8 = "d8";
    public static final String D9 = "d9";
    public static final String D10 = "d10";
    public static final String D10a = "d10a";
    public static final String D10b = "d10b";
    public static final String D11 = "d11";
    public static final String D11a = "d11a";
    public static final String D12 = "d12";
    public static final String D12a = "d12a";
    public static final String D12_IC = "d12-IC ratio";
    public static final String D13 = "d13";
    public static final String D14 = "d14";
    public static final String D15 = "d15";
    public static final String D16 = "d16";
    public static final String D16a = "d16a";
    public static final String D16b = "d16b";
    public static final String D17 = "d17";
    public static final String D18 = "d18";
    public static final String D19 = "d19";
    public static final String D20 = "d20";
    public static final String D9_RMS = "finalRMS";
    public static final String D9_RMSROUND = "rmsRounds";
    public static final String D9_SLEN = "slen";
    public static final String D10L = "d10_lin";
    public static final String D11L = "d11_lin";
    public static final String D12L = "d12_lin";
    public static final String D13L = "d13_lin";
    public static final String D10aL = "d10a_lin";
    public static final String D11aL = "d11a_lin";
    public static final String D12aL = "d12a_lin";
    public static final String D13aL = "d13a_lin";
    public static final String D9_DEFAULT = "s3x5default";
    public static final String D9_FILTER = "d9filter";
    public static final String D12_FILTER = "d12filter";
    public static final String D12_TLEN = "tlen";
    public static final String D9_FILTER_COMPOSIT = "d9filtercomposit";
    public static final String[] ALL_D = new String[]{"d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9", "d10", "d10a", "d10b", "d11", "d11a", "d12", "d12a", "d13", "d14", "d15", "d16", "d16a", "d16b", "d18", "d19", "d20"};
    public static final String E1 = "e1";
    public static final String E2 = "e2";
    public static final String E3 = "e3";
    public static final String E11 = "e11";
    public static final String[] ALL_E = new String[]{"e1", "e2", "e3", "e11"};
    private IX11Toolkit toolkit;
    private TsData refSeries;
    private TsData refCorrection;
    private boolean uscbLike = true;
    private IExtremeValuesCorrector ecorr;

    @Override
    public X11Results process(TsData s) {
        if (this.toolkit == null) {
            this.toolkit = X11Toolkit.create(new X11Specification());
        }
        InformationSet info = new InformationSet();
        X11Context context = this.toolkit.getContext();
        context.check(s);
        DecompositionMode mode = this.toolkit.getContext().getMode();
        info.subSet(A).set(A1, s);
        this.stepA(info);
        this.stepB(info);
        this.stepC(info);
        this.stepD(info);
        this.stepE(info);
        this.stepF(info);
        X11Results results = new X11Results(mode, info);
        return results;
    }

    public IX11Toolkit getToolkit() {
        return this.toolkit;
    }

    public void setToolkit(IX11Toolkit toolkit) {
        this.toolkit = toolkit;
    }

    private void stepA(InformationSet info) {
        if (this.toolkit.getPreprocessor() != null) {
            this.toolkit.getPreprocessor().preprocess(info);
        } else {
            TsData a1 = info.subSet(A).get(A1, TsData.class);
            info.subSet(B).set(B1, a1);
        }
    }

    private void stepB(InformationSet info) {
        TsData b20;
        TsData b13;
        TsData b9d;
        TsData b4d;
        InformationSet btables = info.subSet(B);
        TsData b1 = btables.get(B1, TsData.class);
        this.refSeries = this.toolkit.getContext().isLogAdditive() ? b1.log() : b1;
        TsData b2 = this.toolkit.getTrendCycleComputer().doInitialFiltering(X11Step.B, this.refSeries, info);
        TsData b3 = this.toolkit.getContext().op(this.refSeries, b2);
        TsData b4a = this.toolkit.getSeasonalComputer().doInitialFiltering(X11Step.B, b3, info);
        TsData b4anorm = this.toolkit.getSeasonalNormalizer().normalize(b4a, null);
        if (this.toolkit.getContext().isPseudoAdditive()) {
            b4d = b3.clone();
            b4d.apply(b4anorm, (x, y) -> x - y + 1.0);
        } else {
            b4d = this.toolkit.getContext().op(b3, b4anorm);
        }
        this.ecorr = this.toolkit.getExtremeValuesCorrector();
        if (this.ecorr instanceof CochranDependentExtremeValuesCorrector) {
            ((CochranDependentExtremeValuesCorrector)this.ecorr).testCochran(b4d);
        }
        this.ecorr.analyse(b4d);
        TsData b4 = this.ecorr.computeCorrections(b3);
        TsData b4g = this.ecorr.applyCorrections(b3, b4);
        TsData b5a = this.toolkit.getSeasonalComputer().doInitialFiltering(X11Step.B, b4g, info);
        TsData b5 = this.toolkit.getSeasonalNormalizer().normalize(b5a, this.refSeries.getDomain());
        TsData b6 = this.toolkit.getContext().isPseudoAdditive() ? this.toolkit.getContext().pseudoOp(this.refSeries, b2, b5) : this.toolkit.getContext().op(this.refSeries, b5);
        TsData b7 = this.toolkit.getTrendCycleComputer().doFinalFiltering(X11Step.B, b6, info);
        if (this.toolkit.getContext().isMultiplicative() || this.toolkit.getContext().isPseudoAdditive()) {
            this.toolkit.getUtilities().checkPositivity(b7);
        }
        TsData b8 = this.toolkit.getContext().op(this.refSeries, b7);
        TsData b9a = this.toolkit.getSeasonalComputer().doFinalFiltering(X11Step.B, b8, info);
        TsData b9c = this.toolkit.getSeasonalNormalizer().normalize(b9a, null);
        if (this.toolkit.getContext().isPseudoAdditive()) {
            b9d = b8.clone();
            b9d.apply(b9c, (x, y) -> x - y + 1.0);
        } else {
            b9d = this.toolkit.getContext().op(b8, b9c);
        }
        this.ecorr.analyse(b9d);
        TsData b9 = this.ecorr.computeCorrections(b8);
        TsData b9g = this.ecorr.applyCorrections(b8, b9);
        TsData b10a = this.toolkit.getSeasonalComputer().doFinalFiltering(X11Step.B, b9g, info);
        TsData b10 = this.toolkit.getSeasonalNormalizer().normalize(b10a, null);
        TsData b11 = this.toolkit.getContext().isPseudoAdditive() ? this.refSeries.minus(b7.times(b10.minus(1.0))) : this.toolkit.getContext().op(this.refSeries, b10);
        TsData next = b13 = this.toolkit.getContext().op(b11, b7);
        if (this.ecorr instanceof CochranDependentExtremeValuesCorrector) {
            ((CochranDependentExtremeValuesCorrector)this.ecorr).testCochran(next);
        }
        this.ecorr.analyse(next);
        TsData b17 = this.ecorr.getObservationWeights();
        this.refCorrection = b20 = this.ecorr.getCorrectionFactors();
        if (this.toolkit.getContext().isLogAdditive()) {
            b2.applyOnFinite(x -> Math.exp(x));
            b3.applyOnFinite(x -> Math.exp(x));
            b4.applyOnFinite(x -> Math.exp(x));
            b5.applyOnFinite(x -> Math.exp(x));
            b6.applyOnFinite(x -> Math.exp(x));
            b7.applyOnFinite(x -> Math.exp(x));
            b8.applyOnFinite(x -> Math.exp(x));
            b9.applyOnFinite(x -> Math.exp(x));
            b10.applyOnFinite(x -> Math.exp(x));
            b11.applyOnFinite(x -> Math.exp(x));
            b13.applyOnFinite(x -> Math.exp(x));
            b20 = b20.exp();
        }
        btables.set(B2, b2);
        btables.set(B3, b3);
        btables.set(B4, b4);
        btables.set(B5, b5);
        btables.set(B6, b6);
        btables.set(B7, b7);
        btables.set(B8, b8);
        btables.set(B9, b9);
        btables.set(B10, b10);
        btables.set(B11, b11);
        btables.set(B13, b13);
        btables.set(B17, b17);
        btables.set(B20, b20);
    }

    private void stepC(InformationSet info) {
        TsData c20;
        TsData c13;
        TsData c1;
        InformationSet ctables = info.subSet(C);
        if (this.toolkit.getContext().isPseudoAdditive()) {
            TsData b7 = info.subSet(B).get(B7, TsData.class);
            TsData b13 = info.subSet(B).get(B13, TsData.class);
            c1 = this.refSeries.plus(b7.times(b13.div(this.refCorrection).minus(b13)));
        } else {
            c1 = this.toolkit.getContext().op(this.refSeries, this.refCorrection);
        }
        TsData c2 = this.toolkit.getTrendCycleComputer().doInitialFiltering(X11Step.B, c1, info);
        TsData c4 = this.toolkit.getContext().op(c1, c2);
        TsData c5a = this.toolkit.getSeasonalComputer().doInitialFiltering(X11Step.C, c4, info);
        TsData c5 = this.toolkit.getSeasonalNormalizer().normalize(c5a, c1.getDomain());
        TsData c6 = this.toolkit.getContext().isPseudoAdditive() ? this.toolkit.getContext().pseudoOp(c1, c2, c5) : this.toolkit.getContext().op(c1, c5);
        TsData c7 = this.toolkit.getTrendCycleComputer().doFinalFiltering(X11Step.C, c6, info);
        if (this.toolkit.getContext().isMultiplicative() || this.toolkit.getContext().isPseudoAdditive()) {
            this.toolkit.getUtilities().checkPositivity(c7);
        }
        TsData c9 = this.toolkit.getContext().op(c1, c7);
        TsData c10a = this.toolkit.getSeasonalComputer().doFinalFiltering(X11Step.C, c9, info);
        TsData c10 = this.toolkit.getSeasonalNormalizer().normalize(c10a, null);
        TsData c11 = this.toolkit.getContext().isPseudoAdditive() ? this.refSeries.minus(c7.times(c10.minus(1.0))) : this.toolkit.getContext().op(this.refSeries, c10);
        TsData next = c13 = this.toolkit.getContext().op(c11, c7);
        IExtremeValuesCorrector ecorr = this.toolkit.getExtremeValuesCorrector();
        ecorr.analyse(next);
        TsData c17 = ecorr.getObservationWeights();
        this.refCorrection = c20 = ecorr.getCorrectionFactors();
        if (this.toolkit.getContext().isLogAdditive()) {
            c1.applyOnFinite(x -> Math.exp(x));
            c2.applyOnFinite(x -> Math.exp(x));
            c4.applyOnFinite(x -> Math.exp(x));
            c5.applyOnFinite(x -> Math.exp(x));
            c6.applyOnFinite(x -> Math.exp(x));
            c7.applyOnFinite(x -> Math.exp(x));
            c9.applyOnFinite(x -> Math.exp(x));
            c10.applyOnFinite(x -> Math.exp(x));
            c11.applyOnFinite(x -> Math.exp(x));
            c13.applyOnFinite(x -> Math.exp(x));
            c20 = c20.exp();
        }
        ctables.set(C1, c1);
        ctables.set(C2, c2);
        ctables.set(C4, c4);
        ctables.set(C5, c5);
        ctables.set(C6, c6);
        ctables.set(C7, c7);
        ctables.set(C9, c9);
        ctables.set(C10, c10);
        ctables.set(C11, c11);
        ctables.set(C13, c13);
        ctables.set(C17, c17);
        ctables.set(C20, c20);
    }

    private void stepD(InformationSet info) {
        TsData d11;
        TsData d10b;
        TsData d10;
        TsData d9;
        TsData d1;
        InformationSet dtables = info.subSet(D);
        TsDomain sdomain = this.toolkit.getContext().getEstimationDomain();
        if (this.toolkit.getContext().isPseudoAdditive()) {
            TsData c7 = info.subSet(C).get(C7, TsData.class);
            TsData c13 = info.subSet(C).get(C13, TsData.class);
            d1 = this.refSeries.plus(c7.times(c13.div(this.refCorrection).minus(c13)));
        } else {
            d1 = this.toolkit.getContext().op(this.refSeries, this.refCorrection);
        }
        TsData d2 = this.toolkit.getTrendCycleComputer().doInitialFiltering(X11Step.D, d1, info);
        TsData d4 = this.toolkit.getContext().op(d1, d2);
        TsData d5a = this.toolkit.getSeasonalComputer().doInitialFiltering(X11Step.D, d4, info);
        TsData d5 = this.toolkit.getSeasonalNormalizer().normalize(d5a, d1.getDomain());
        TsData d6 = this.toolkit.getContext().isPseudoAdditive() ? this.toolkit.getContext().pseudoOp(d1, d2, d5) : this.toolkit.getContext().op(d1, d5);
        TsData d7 = this.toolkit.getTrendCycleComputer().doFinalFiltering(X11Step.D, d6, info);
        if (this.toolkit.getContext().isMultiplicative() || this.toolkit.getContext().isPseudoAdditive()) {
            this.toolkit.getUtilities().checkPositivity(d7);
        }
        TsData d8a = this.toolkit.getContext().op(d1, d7);
        TsData d8 = this.toolkit.getContext().invOp(d8a, this.refCorrection);
        if (this.ecorr instanceof PeriodSpecificExtremeValuesCorrector) {
            d9 = this.ecorr.computeCorrections(d8.drop(0, this.toolkit.getContext().getForecastHorizon()));
            d9.extend(0, this.toolkit.getContext().getForecastHorizon());
            TsData d9g = this.ecorr.applyCorrections(d8, d9);
            TsData d10a = this.toolkit.getSeasonalComputer().doFinalFiltering(X11Step.D, d9g, info);
            d10 = this.toolkit.getSeasonalNormalizer().normalize(d10a, null);
        } else {
            TsData d9bis = this.toolkit.getContext().op(d1, d7);
            d9 = this.toolkit.getUtilities().differences(d9bis, d8);
            TsData d10bis = this.toolkit.getSeasonalComputer().doFinalFiltering(X11Step.D, d9bis, info);
            d10 = this.toolkit.getSeasonalNormalizer().normalize(d10bis, null);
        }
        TsData d11bis = this.toolkit.getContext().isPseudoAdditive() ? d1.minus(d7.times(d10.minus(1.0))) : this.toolkit.getContext().op(d1, d10);
        boolean[] valid = this.toolkit.getContext().getValidDecomposition();
        if (valid != null) {
            TsData tmp = d11bis.fittoDomain(sdomain);
            for (int i = 0; i < valid.length; ++i) {
                if (!valid[i] || !(tmp.get(i) <= 0.0)) continue;
                valid[i] = false;
            }
        }
        TsData d12 = this.toolkit.getTrendCycleComputer().doFinalFiltering(X11Step.D, d11bis, info);
        ICRatioComputer.writeICR(this.toolkit.getContext(), d11bis, info);
        if (this.toolkit.getContext().isMultiplicative() || this.toolkit.getContext().isPseudoAdditive()) {
            this.toolkit.getUtilities().checkPositivity(d12);
        }
        if (this.toolkit.getContext().isPseudoAdditive()) {
            d10b = d12.times(d10.minus(1.0));
            d11 = this.refSeries.minus(d10b);
        } else {
            d10b = null;
            d11 = this.toolkit.getContext().op(this.refSeries, d10);
        }
        TsData d13 = this.toolkit.getContext().op(d11, d12);
        if (this.toolkit.getContext().getMode() == DecompositionMode.LogAdditive) {
            d1.applyOnFinite(x -> Math.exp(x));
            d2.applyOnFinite(x -> Math.exp(x));
            d4.applyOnFinite(x -> Math.exp(x));
            d5.applyOnFinite(x -> Math.exp(x));
            d6.applyOnFinite(x -> Math.exp(x));
            d7.applyOnFinite(x -> Math.exp(x));
            d8.applyOnFinite(x -> Math.exp(x));
            d9.applyOnFinite(x -> Math.exp(x));
            d10.applyOnFinite(x -> Math.exp(x));
            d11.applyOnFinite(x -> Math.exp(x));
            d12.applyOnFinite(x -> Math.exp(x));
            d13.applyOnFinite(x -> Math.exp(x));
            TsData b1 = info.subSet(B).get(B1, TsData.class);
            this.toolkit.getContext().setMode(DecompositionMode.Multiplicative);
            if (this.uscbLike) {
                TsData c13 = info.subSet(C).get(C13, TsData.class);
                d12 = this.toolkit.getUtilities().correctTrendBias(d12, d10, c13, this.toolkit.getBiasCorrection());
            } else {
                d12 = this.toolkit.getUtilities().correctTrendBias(d12, d10, d13);
            }
            this.toolkit.getUtilities().checkPositivity(d12);
            d11 = this.toolkit.getContext().op(b1, d10);
            d13 = this.toolkit.getContext().op(d11, d12);
        }
        dtables.set(D1, d1.fittoDomain(sdomain));
        dtables.set(D2, d2.fittoDomain(sdomain));
        dtables.set(D4, d4.fittoDomain(sdomain));
        dtables.set(D5, d5.fittoDomain(sdomain));
        dtables.set(D6, d6.fittoDomain(sdomain));
        dtables.set(D7, d7.fittoDomain(sdomain));
        dtables.set(D8, d8.fittoDomain(sdomain));
        dtables.set(D9, d9.fittoDomain(sdomain));
        if (d10b != null) {
            dtables.set(D10b, d10b.fittoDomain(sdomain));
        }
        dtables.set(D10L, d10.fittoDomain(sdomain));
        dtables.set(D11L, d11.fittoDomain(sdomain));
        dtables.set(D12L, d12.fittoDomain(sdomain));
        dtables.set(D13L, d13.fittoDomain(sdomain));
        InformationSet atables = info.subSet(A);
        TsData a1 = atables.get(A1, TsData.class);
        TsData a8t = atables.get(A8t, TsData.class);
        TsData a8i = atables.get(A8i, TsData.class);
        TsData a8s = atables.get(A8s, TsData.class);
        TsData d10c = this.toolkit.getContext().invOp(d10, a8s);
        dtables.set(D10, d10c.fittoDomain(sdomain));
        TsData d12c = this.toolkit.getContext().invOp(d12, a8t);
        TsData d13c = this.toolkit.getContext().invOp(d13, a8i);
        TsData d11c = this.toolkit.getContext().invOp(d11, a8t);
        d11c = this.toolkit.getContext().invOp(d11c, a8i);
        TsData a9sa = atables.get(A9sa, TsData.class);
        d11c = this.toolkit.getContext().invOp(d11c, a9sa);
        TsData d16 = this.toolkit.getContext().isPseudoAdditive() ? a1.div(d12).minus(d13).plus(1.0) : this.toolkit.getContext().op(a1, d11c);
        dtables.set(D11, d11c.fittoDomain(sdomain));
        dtables.set(D12, d12c.fittoDomain(sdomain));
        dtables.set(D13, d13c.fittoDomain(sdomain));
        dtables.set(D16, d16);
        dtables.set(D18, this.toolkit.getContext().op(d16, d10c));
        int nf = this.toolkit.getContext().getForecastHorizon();
        if (nf > 0) {
            TsData a1a = atables.get(A1a, TsData.class);
            TsData d16a = this.toolkit.getContext().isPseudoAdditive() ? a1a.div(d12).minus(d13).plus(1.0) : this.toolkit.getContext().op(a1a, d11c);
            TsDomain fdomain = new TsDomain(sdomain.getEnd(), nf);
            dtables.set(D10a, d10c.fittoDomain(fdomain));
            dtables.set(D10aL, d10.fittoDomain(fdomain));
            dtables.set(D11a, d11c.fittoDomain(fdomain));
            dtables.set(D11aL, d11.fittoDomain(fdomain));
            dtables.set(D12a, d12c.fittoDomain(fdomain));
            dtables.set(D12aL, d12.fittoDomain(fdomain));
            dtables.set(D16a, d16a);
        } else {
            int freq = this.toolkit.getContext().getFrequency();
            TsDomain fdomain = new TsDomain(sdomain.getEnd(), freq);
            TsData d10a = new TsData(fdomain);
            int i = 0;
            int k = sdomain.getLength() - freq;
            while (i < freq) {
                d10a.set(i, (d10.get(k) * 3.0 - d10.get(k - freq)) / 2.0);
                ++i;
                ++k;
            }
            dtables.set(D10a, d10a);
            dtables.set(D10aL, d10a);
            TsData a6 = atables.get(A6, TsData.class);
            TsData a7 = atables.get(A7, TsData.class);
            TsData d16a = this.toolkit.getContext().invOp(d10a, a6);
            d16a = this.toolkit.getContext().invOp(d16a, a7);
            d16a = this.toolkit.getContext().invOp(d16a, a8s);
            dtables.set(D16a, d16a);
        }
        int nb = this.toolkit.getContext().getBackcastHorizon();
        if (nb > 0) {
            TsDomain bdomain = new TsDomain(sdomain.getStart().minus(nb), nb);
            TsData a1b = atables.get(A1b, TsData.class);
            TsData d16b = this.toolkit.getContext().op(a1b, d11c);
            dtables.set(D16b, d16b);
            dtables.set(D10b, d10c.fittoDomain(bdomain));
        }
    }

    void stepE(InformationSet info) {
        InformationSet atables = info.subSet(A);
        TsData a1 = atables.get(A1, TsData.class);
        TsData a8i = atables.get(A8i, TsData.class);
        InformationSet ctables = info.subSet(C);
        TsData c17 = ctables.get(C17, TsData.class);
        InformationSet dtables = info.subSet(D);
        TsData d16 = dtables.get(D16, TsData.class);
        TsData d11 = dtables.get(D11, TsData.class);
        TsData d12 = dtables.get(D12, TsData.class);
        TsData d13l = dtables.get(D13L, TsData.class);
        TsData d13 = dtables.get(D13, TsData.class);
        TsData a1c = this.toolkit.getContext().op(a1, a8i);
        TsData d11c = this.toolkit.getContext().op(d11, a8i);
        TsData tmp = this.toolkit.getContext().op(a1, d13);
        TsData e1 = this.toolkit.getUtilities().correctSeries(a1c, c17, tmp);
        TsData e2 = this.toolkit.getUtilities().correctSeries(d11c, c17, d12);
        TsData e3 = this.toolkit.getUtilities().correctSeries(d13l, c17, this.toolkit.getContext().getMean());
        TsData e11 = this.toolkit.getUtilities().correctSeries(d11c, c17, TsData.add(d12, TsData.subtract(a1c, e1)));
        InformationSet etables = info.subSet(E);
        etables.set(E1, e1);
        etables.set(E2, e2);
        etables.set(E3, e3);
        etables.set(E11, e11);
    }

    private void stepF(InformationSet info) {
    }
}

