/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.PeriodSpecificExtremeValuesCorrector;
import ec.satoolkit.x11.SigmavecOption;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.simplets.PeriodIterator;

public class GroupSpecificExtremeValuesCorrector
extends PeriodSpecificExtremeValuesCorrector {
    private SigmavecOption[] sigmavecOption_;

    public void setSigmavecOption(SigmavecOption[] sigmavecOption) {
        this.sigmavecOption_ = sigmavecOption;
    }

    @Override
    protected void calcStdev() {
        double stdvGroup1 = 0.0;
        double stdvGroup2 = 0.0;
        PeriodIterator iteri = new PeriodIterator(this.scur);
        Integer np = this.scur.getFrequency().intValue();
        this.stdev = new double[np.intValue()];
        int i = 0;
        int nGroup1 = 0;
        int nGroup2 = 0;
        double eGroup1 = 0.0;
        double eGroup2 = 0.0;
        while (iteri.hasMoreElements()) {
            double x;
            int j;
            DataBlock dbi = iteri.nextElement().data;
            if (this.sigmavecOption_[i].equals((Object)SigmavecOption.Group1)) {
                for (j = 0; j < dbi.getLength(); ++j) {
                    x = dbi.get(j);
                    if (Double.isNaN(x)) continue;
                    ++nGroup1;
                    if (this.isMultiplicative()) {
                        x -= 1.0;
                    }
                    eGroup1 += x * x;
                }
            } else if (this.sigmavecOption_[i].equals((Object)SigmavecOption.Group2)) {
                for (j = 0; j < dbi.getLength(); ++j) {
                    x = dbi.get(j);
                    if (Double.isNaN(x)) continue;
                    ++nGroup2;
                    if (this.isMultiplicative()) {
                        x -= 1.0;
                    }
                    eGroup2 += x * x;
                }
            }
            ++i;
        }
        stdvGroup1 = Math.sqrt(eGroup1 / (double)nGroup1);
        stdvGroup2 = Math.sqrt(eGroup2 / (double)nGroup2);
        for (i = 0; i < np; ++i) {
            if (this.sigmavecOption_[i].equals((Object)SigmavecOption.Group1)) {
                this.stdev[i] = stdvGroup1;
                continue;
            }
            if (!this.sigmavecOption_[i].equals((Object)SigmavecOption.Group2)) continue;
            this.stdev[i] = stdvGroup2;
        }
    }
}

