/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.special;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.special.GeneralizedAirlineModel;
import ec.tstoolkit.arima.special.GeneralizedAirlineMonitor;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.DisturbanceSmoother;
import ec.tstoolkit.ssf.FastFilter;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.ucarima.SsfUcarima;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.ucarima.UcarimaModel;
import ec.tstoolkit.ucarima.WienerKolmogorovEstimators;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class GeneralizedAirlineResults
implements ISaResults {
    public static final String MODEL = "model";
    public static final String SERIES = "series";
    public static final String LEVEL = "level";
    public static final String SLOPE = "slope";
    public static final String NOISE = "noise";
    public static final String SEASONAL = "seasonal";
    public static final String RESIDUALS = "residuals";
    private GeneralizedAirlineMonitor monitor_;
    private final InformationSet info_ = new InformationSet();
    private final TsData y_;
    private final TsData t_;
    private final TsData sa_;
    private final TsData s_;
    private final TsData i_;
    private final UcarimaModel ucm_;
    private WienerKolmogorovEstimators wk_;
    private boolean mul_;
    private final RegArimaEstimation<GeneralizedAirlineModel> best_;
    private static final InformationMapping<GeneralizedAirlineResults> MAPPING = new InformationMapping<GeneralizedAirlineResults>(GeneralizedAirlineResults.class);

    public GeneralizedAirlineResults(TsData y, GeneralizedAirlineMonitor monitor, boolean b) {
        this.y_ = y;
        this.mul_ = b;
        this.monitor_ = monitor;
        int best = monitor.searchBestEstimation();
        if (best < 0) {
            this.best_ = null;
            this.ucm_ = null;
            this.t_ = null;
            this.sa_ = null;
            this.s_ = null;
            this.i_ = null;
        } else {
            this.best_ = monitor.getBestResult();
            UcarimaModel ucm = this.doCanonicalDecomposition(monitor);
            if (ucm != null) {
                SsfUcarima ssf = new SsfUcarima(ucm);
                DisturbanceSmoother smoother = new DisturbanceSmoother();
                smoother.setSsf(ssf);
                FastFilter<SsfUcarima> filter = new FastFilter<SsfUcarima>();
                filter.setSsf(ssf);
                DiffuseFilteringResults frslts = new DiffuseFilteringResults(true);
                filter.process(new SsfData(this.y_.internalStorage(), null), frslts);
                smoother.process(new SsfData(this.y_.internalStorage(), null), frslts);
                SmoothingResults srslts = smoother.calcSmoothedStates();
                TsData[] cmps = new TsData[ucm.getComponentsCount()];
                for (int i = 0; i < ucm.getComponentsCount(); ++i) {
                    double[] tmp = srslts.component(ssf.cmpPos(i));
                    cmps[i] = new TsData(this.y_.getStart(), tmp, false);
                }
                int cur = 0;
                this.ucm_ = ucm;
                this.t_ = cmps[cur++];
                this.s_ = cmps[cur];
                this.sa_ = TsData.subtract(this.y_, cmps[cur++]);
                this.i_ = cmps[cur];
            } else {
                this.ucm_ = null;
                this.t_ = null;
                this.s_ = null;
                this.sa_ = null;
                this.i_ = null;
            }
        }
    }

    private UcarimaModel doCanonicalDecomposition(GeneralizedAirlineMonitor monitor) {
        try {
            UcarimaModel ucm = ((GeneralizedAirlineModel)this.best_.model.getArima()).toUCModel(monitor.getSpecification().getURBound());
            if (ucm == null) {
                return null;
            }
            if (monitor.isMeanCorrection()) {
                UcarimaModel tmp = new UcarimaModel();
                ArimaModel tm = ucm.getComponent(0);
                BackFilter ur = BackFilter.D1;
                tm = tm.isNull() ? new ArimaModel(null, ur, ur, 0.0) : new ArimaModel(tm.getStationaryAR(), tm.getNonStationaryAR().times(ur), tm.getMA().times(ur), tm.getInnovationVariance());
                tmp.addComponent(tm);
                for (int i = 1; i < ucm.getComponentsCount(); ++i) {
                    tmp.addComponent(ucm.getComponent(i));
                }
                return tmp;
            }
            return ucm;
        }
        catch (Exception err) {
            return null;
        }
    }

    public List<String> getTsDataDictionary() {
        return this.info_.getDictionary(TsData.class);
    }

    public TsData getTsData(String id) {
        return this.info_.search(id, TsData.class);
    }

    @Override
    public boolean contains(String id) {
        if (MAPPING.contains(id)) {
            return true;
        }
        if (this.info_ != null) {
            if (!id.contains(InformationSet.STRSEP)) {
                return this.info_.deepSearch(id, Object.class) != null;
            }
            return this.info_.search(id, Object.class) != null;
        }
        return false;
    }

    @Override
    public ISeriesDecomposition getSeriesDecomposition() {
        DefaultSeriesDecomposition decomposition = new DefaultSeriesDecomposition(this.mul_ ? DecompositionMode.Multiplicative : DecompositionMode.Additive);
        if (this.mul_) {
            decomposition.add(this.y_.exp(), ComponentType.Series);
            decomposition.add(this.sa_.exp(), ComponentType.SeasonallyAdjusted);
            decomposition.add(this.t_.exp(), ComponentType.Trend);
            decomposition.add(this.s_.exp(), ComponentType.Seasonal);
            decomposition.add(this.i_.exp(), ComponentType.Irregular);
        } else {
            decomposition.add(this.y_, ComponentType.Series);
            decomposition.add(this.sa_, ComponentType.SeasonallyAdjusted);
            decomposition.add(this.t_, ComponentType.Trend);
            decomposition.add(this.s_, ComponentType.Seasonal);
            decomposition.add(this.i_, ComponentType.Irregular);
        }
        return decomposition;
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, map, false);
        return map;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        if (MAPPING.contains(id)) {
            return MAPPING.getData(this, id, tclass);
        }
        if (this.info_ != null) {
            if (!id.contains(InformationSet.STRSEP)) {
                return this.info_.deepSearch(id, tclass);
            }
            return this.info_.search(id, tclass);
        }
        return null;
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.EMPTY_LIST;
    }

    public UcarimaModel getUcarimaModel() {
        return this.ucm_;
    }

    public WienerKolmogorovEstimators getWienerKolmogorovEstimators() {
        if (this.ucm_ == null) {
            return null;
        }
        if (this.wk_ == null) {
            this.wk_ = new WienerKolmogorovEstimators(this.ucm_);
        }
        return this.wk_;
    }

    public int getResultsCount() {
        return this.monitor_.getResultsCount();
    }

    public RegArimaEstimation<GeneralizedAirlineModel> getResult(int idx) {
        return this.monitor_.result(idx);
    }

    public RegArimaEstimation<GeneralizedAirlineModel> getBestResult() {
        return this.monitor_.getBestResult();
    }

    public TsData getResiduals() {
        TsDomain domain = this.y_.getDomain();
        double[] res = this.monitor_.getBestResult().likelihood.getResiduals();
        return new TsData(domain.getStart().plus(domain.getLength() - res.length), res, false);
    }

    @Override
    public InformationSet getInformation() {
        return this.info_;
    }

    public static InformationMapping<GeneralizedAirlineResults> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<GeneralizedAirlineResults, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<GeneralizedAirlineResults, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    static {
        MAPPING.set("y_cmp", source -> source.mul_ ? source.y_.exp() : source.y_);
        MAPPING.set("t_cmp", source -> {
            if (source.t_ == null) {
                return null;
            }
            return source.mul_ ? source.t_.exp() : source.t_;
        });
        MAPPING.set("sa_cmp", source -> {
            if (source.sa_ == null) {
                return null;
            }
            return source.mul_ ? source.sa_.exp() : source.sa_;
        });
        MAPPING.set("s_cmp", source -> {
            if (source.s_ == null) {
                return null;
            }
            return source.mul_ ? source.s_.exp() : source.s_;
        });
        MAPPING.set("i_cmp", source -> {
            if (source.i_ == null) {
                return null;
            }
            return source.mul_ ? source.i_.exp() : source.i_;
        });
        MAPPING.set("si_cmp", source -> {
            TsData si = TsData.add(source.s_, source.i_);
            if (si == null) {
                return null;
            }
            return source.mul_ ? si.exp() : si;
        });
        MAPPING.set("y_lin", source -> source.y_);
        MAPPING.set("t_lin", source -> source.t_);
        MAPPING.set("sa_lin", source -> source.sa_);
        MAPPING.set("s_lin", source -> source.s_);
        MAPPING.set("i_lin", source -> source.i_);
        MAPPING.set(RESIDUALS, source -> source.getResiduals());
    }
}

